/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.protobuf.io;

import com.complexible.common.protobuf.io.ProtobufReader;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamSizeDelimitedProtobufReader<T extends MessageLite>
implements ProtobufReader<T> {
    private final InputStream mStream;
    private final ExtensionRegistry mExtensionRegistry;
    private final T mPrototype;
    private final byte[] array = new byte[4];

    public InputStreamSizeDelimitedProtobufReader(InputStream theStream, T thePrototype) {
        this(theStream, thePrototype, null);
    }

    public InputStreamSizeDelimitedProtobufReader(InputStream theStream, T thePrototype, ExtensionRegistry theExtensionRegistry) {
        this.mStream = theStream;
        this.mPrototype = thePrototype;
        this.mExtensionRegistry = theExtensionRegistry;
    }

    @Override
    public T read() throws InvalidProtocolBufferException, IOException {
        try {
            ByteStreams.readFully((InputStream)this.mStream, (byte[])this.array);
            int aSize = Ints.fromByteArray((byte[])this.array);
            byte[] aData = new byte[aSize];
            ByteStreams.readFully((InputStream)this.mStream, (byte[])aData);
            if (this.mExtensionRegistry == null) {
                return (T)this.mPrototype.newBuilderForType().mergeFrom(aData).build();
            }
            return (T)this.mPrototype.newBuilderForType().mergeFrom(aData, (ExtensionRegistryLite)this.mExtensionRegistry).build();
        }
        catch (EOFException e) {
            return null;
        }
    }
}

