/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.rdfjson;

import com.complexible.common.base.Options;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Statements;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.rdfjson.RDFJSON;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFJSONWriter
implements RDFWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDFJSONWriter.class);
    private final OutputStream mOut;
    private final Options mOptions;
    private final Set<Statement> mGraph = new HashSet<Statement>();

    public RDFJSONWriter(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
        this.mOut = theStream;
        this.mOptions = theOptions;
    }

    public void end() {
        try (JsonGenerator jg = RDFJSON.JSON_FACTORY.createGenerator(this.mOut);){
            RDFJSONWriter.modelToRdfJsonInternal(this.mGraph, this.mOptions, jg);
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
        finally {
            try {
                this.mOut.flush();
            }
            catch (IOException e) {
                LOGGER.warn("There was an unexpected error flushing the stream", (Throwable)e);
            }
        }
    }

    public void comment(@Nonnull String theComment) {
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
    }

    public void handle(@Nonnull Statement theStmt) {
        this.mGraph.add(theStmt);
    }

    public void start() {
        this.mGraph.clear();
    }

    static void writeObject(Value object, Set<Resource> contexts, JsonGenerator jg) throws IOException {
        jg.writeStartObject();
        if (object instanceof Literal) {
            jg.writeObjectField("value", (Object)((Literal)object).label());
            jg.writeObjectField("type", (Object)"literal");
            Literal l = (Literal)object;
            if (Literal.isLanguageLiteral((Literal)l)) {
                jg.writeObjectField("lang", l.lang().orElse(null));
            } else {
                jg.writeObjectField("datatype", (Object)l.datatypeIRI().toString());
            }
        } else if (object instanceof BNode) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((Resource)((BNode)object)));
            jg.writeObjectField("type", (Object)"bnode");
        } else if (object instanceof IRI) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((Resource)((IRI)object)));
            jg.writeObjectField("type", (Object)"uri");
        }
        if (!(contexts == null || contexts.isEmpty() || contexts.size() == 1 && contexts.iterator().next() == null)) {
            jg.writeArrayFieldStart("graphs");
            for (Resource nextContext : contexts) {
                if (nextContext == null) {
                    jg.writeNull();
                    continue;
                }
                jg.writeString(RDFJSONWriter.resourceToString(nextContext));
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    public static String resourceToString(Resource uriOrBnode) {
        if (uriOrBnode instanceof IRI) {
            return uriOrBnode.toString();
        }
        return "_:" + ((BNode)uriOrBnode).id();
    }

    static void modelToRdfJsonInternal(Set<Statement> graph, Options writerConfig, JsonGenerator jg) throws IOException {
        if (((Boolean)writerConfig.get(WriterOptions.PRETTY_PRINT)).booleanValue()) {
            DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
            DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter);
            jg.setPrettyPrinter((PrettyPrinter)pp);
        }
        jg.writeStartObject();
        Iterator aIterator = graph.stream().map(Statement::subject).distinct().iterator();
        while (aIterator.hasNext()) {
            Resource nextSubject = (Resource)aIterator.next();
            jg.writeObjectFieldStart(RDFJSONWriter.resourceToString(nextSubject));
            Iterator pIter = graph.stream().filter(Statements.matches((Resource)nextSubject, null, null, (Resource[])new Resource[0])).map(Statement::predicate).distinct().iterator();
            while (pIter.hasNext()) {
                IRI nextPredicate = (IRI)pIter.next();
                jg.writeArrayFieldStart(nextPredicate.toString());
                Iterator oIter = graph.stream().filter(Statements.matches((Resource)nextSubject, (IRI)nextPredicate, null, (Resource[])new Resource[0])).map(Statement::object).distinct().iterator();
                while (oIter.hasNext()) {
                    Value nextObject = (Value)oIter.next();
                    Set<Resource> contexts = graph.stream().filter(Statements.matches((Resource)nextSubject, (IRI)nextPredicate, (Value)nextObject, (Resource[])new Resource[0])).map(Statement::context).filter(c -> c != Values.DEFAULT_GRAPH).distinct().collect(Collectors.toSet());
                    RDFJSONWriter.writeObject(nextObject, contexts, jg);
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.RDFJSON;
    }

    public static final class RDFJSONWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.RDFJSON;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new RDFJSONWriter(theStream, theOptions);
        }
    }
}

