/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.search;

import com.complexible.common.base.Copyable;
import com.stardog.stark.Resource;

public final class SearchResult
implements Copyable<SearchResult> {
    private final double mScore;
    private final int mIndex;
    private final Resource mHit;

    private SearchResult(Resource theHit, double theScore, int theIndex) {
        this.mHit = theHit;
        this.mScore = theScore;
        this.mIndex = theIndex;
    }

    public static SearchResult create(Resource theHit, double theScore, int theIndex) {
        return new SearchResult(theHit, theScore, theIndex);
    }

    public SearchResult copy() {
        return new SearchResult(this.mHit, this.mScore, this.mIndex);
    }

    public double getScore() {
        return this.mScore;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public Resource getHit() {
        return this.mHit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        if (this.mIndex != that.mIndex) {
            return false;
        }
        if (Double.compare(that.mScore, this.mScore) != 0) {
            return false;
        }
        return !(this.mHit != null ? !this.mHit.equals((Object)that.mHit) : that.mHit != null);
    }

    public int hashCode() {
        long temp = this.mScore != 0.0 ? Double.doubleToLongBits(this.mScore) : 0L;
        int aresult = (int)(temp ^ temp >>> 32);
        aresult = 31 * aresult + this.mIndex;
        aresult = 31 * aresult + (this.mHit != null ? this.mHit.hashCode() : 0);
        return aresult;
    }

    public String toString() {
        return this.getScore() + " " + String.valueOf(this.getHit());
    }
}

