/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.rdf.query.TupleQueryResultIterator;
import com.complexible.stardog.Contexts;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.Connection;
import com.complexible.stardog.api.SelectQuery;
import com.complexible.stardog.api.impl.AbstractSearcher;
import com.complexible.stardog.api.search.SearchResult;
import com.complexible.stardog.api.search.SearchResults;
import com.google.common.collect.ImmutableList;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.SelectQueryResult;
import java.util.List;
import java.util.function.Function;

public final class DefaultSearcherImpl
extends AbstractSearcher {
    private final Connection mConn;

    public DefaultSearcherImpl(Connection theConn) {
        this.mConn = theConn;
    }

    @Override
    protected SearchResults _search() throws StardogException {
        try {
            Object theQuery = "SELECT distinct ?s ?score \n";
            String aTemplate = "FROM <%s>%n";
            if (this.mContexts.contains(Contexts.LOCAL) || this.mContexts.contains(Contexts.ALL)) {
                theQuery = (String)theQuery + String.format("FROM <%s>%n", Contexts.LOCAL);
            } else if (this.mContexts.contains(Contexts.NAMED)) {
                theQuery = (String)theQuery + String.format("FROM <%s>%n", Contexts.NAMED);
            } else {
                for (Resource aCxt : this.mContexts) {
                    theQuery = (String)theQuery + String.format("FROM <%s>%n", aCxt);
                }
            }
            if (this.mSemantic) {
                theQuery = "PREFIX fts: <tag:stardog:api:search:>\n" + (String)theQuery;
                theQuery = (String)theQuery + "WHERE {\n?s ?p ?o .\n  service fts:textMatch {\n    [] fts:result ?o ;\n       fts:query ?term ;\n       fts:score ?score ;\n       fts:threshold ?threshold ;\n       fts:limit ?limit ;\n       fts:semantic true ;\n  }\n}\norder by desc(?score) ?s";
            } else {
                theQuery = (String)theQuery + "WHERE { ?s ?p ?o .\n( ?o ?score ) <http://jena.hpl.hp.com/ARQ/property#textMatch> ( ?term ?threshold ?limit ?offset ) .\n}\norder by desc(?score) ?s";
            }
            SelectQuery aQuery = this.mConn.select((String)theQuery);
            aQuery.parameter("term", this.mQuery);
            aQuery.parameter("threshold", this.mThreshold);
            aQuery.parameter("limit", this.mLimit);
            aQuery.parameter("offset", this.mOffset);
            SelectQueryResult aResult = (SelectQueryResult)aQuery.execute();
            CloseableIterator iteration = CloseableIterator.transform((CloseableIterator)new TupleQueryResultIterator(aResult), (Function)new Function<BindingSet, SearchResult>(){
                private int index;
                {
                    this.index = DefaultSearcherImpl.this.mOffset;
                }

                @Override
                public SearchResult apply(BindingSet bs) {
                    Resource sRes = (Resource)bs.resource("s").get();
                    Literal scoreLit = (Literal)bs.literal("score").get();
                    return SearchResult.create(sRes, Literal.doubleValue((Literal)scoreLit), this.index++);
                }
            });
            return new SearchResults(this.mQuery, (CloseableIterator<SearchResult>)iteration, (List<String>)ImmutableList.of(), this.mOffset);
        }
        catch (Exception e) {
            throw new StardogException((Throwable)e);
        }
    }
}

