/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.api.impl;

import com.complexible.stardog.StardogException;
import com.complexible.stardog.api.search.SearchResults;
import com.complexible.stardog.api.search.Searcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.stardog.stark.Resource;
import java.util.Set;

public abstract class AbstractSearcher
implements Searcher {
    protected int mOffset = 0;
    protected int mLimit = 50;
    protected double mThreshold = -1.0;
    protected String mQuery = null;
    protected Set<Resource> mContexts = ImmutableSet.of();
    protected boolean mSemantic = false;

    protected abstract SearchResults _search() throws StardogException;

    @Override
    public Searcher in(Resource ... theGraphs) {
        this.mContexts = ImmutableSet.copyOf((Object[])theGraphs);
        return this;
    }

    @Override
    public final SearchResults search() throws StardogException {
        Preconditions.checkNotNull((Object)this.mQuery, (Object)"Must provide a search string");
        return this._search();
    }

    @Override
    public Searcher query(String theQuery) {
        Preconditions.checkNotNull((Object)theQuery, (Object)"Search string cannot be null");
        this.mQuery = theQuery;
        return this;
    }

    @Override
    public Searcher threshold(double theThreshold) {
        if (theThreshold != -1.0) {
            Preconditions.checkArgument((theThreshold >= 0.0 ? 1 : 0) != 0, (Object)"Threshold must be greater than or equal to zero.");
            this.mThreshold = theThreshold;
        }
        return this;
    }

    @Override
    public Searcher limit(int theLimit) {
        Preconditions.checkArgument((theLimit >= 0 ? 1 : 0) != 0, (Object)"Limit must be greater than or equal to zero.");
        this.mLimit = theLimit;
        return this;
    }

    @Override
    public Searcher offset(int theOffset) {
        Preconditions.checkArgument((theOffset >= 0 ? 1 : 0) != 0, (Object)"Offset must be greater than or equal to zero.");
        this.mOffset = theOffset;
        return this;
    }

    @Override
    public Searcher semantic(boolean theSemantic) {
        this.mSemantic = theSemantic;
        return this;
    }
}

