/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.license;

import com.clarkparsia.license.Company;
import com.clarkparsia.license.Person;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class PersonImpl
implements Person {
    private final String mName;
    private final String mEmail;
    private final Company mCompany;

    public PersonImpl(String theName, String theEmail, Company theCompany) {
        this.mName = (String)Preconditions.checkNotNull((Object)theName);
        this.mEmail = (String)Preconditions.checkNotNull((Object)theEmail);
        this.mCompany = (Company)Preconditions.checkNotNull((Object)theCompany);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mCompany, this.mEmail});
    }

    public boolean equals(Object theObj) {
        if (theObj == this) {
            return true;
        }
        if (theObj instanceof PersonImpl) {
            PersonImpl aPerson = (PersonImpl)theObj;
            return Objects.equal((Object)this.mName, (Object)aPerson.mName) && Objects.equal((Object)this.mEmail, (Object)aPerson.mEmail) && Objects.equal((Object)this.mCompany, (Object)aPerson.mCompany);
        }
        return false;
    }

    public String toString() {
        return String.format("%s (%s)%s", this.mName, this.mEmail, this.mCompany != null ? ", " + this.mCompany.getName() : "");
    }

    @Override
    public Company getCompany() {
        return this.mCompany;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getEmail() {
        return this.mEmail;
    }
}

