/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.license;

import com.clarkparsia.license.ExpiredLicenseContent;
import com.clarkparsia.license.ExpiredLicenseException;
import com.clarkparsia.license.InvalidLicenseException;
import com.clarkparsia.license.InvalidLicenseVersionException;
import com.clarkparsia.license.License;
import com.clarkparsia.license.LicenseConstants;
import com.clarkparsia.license.LicenseContentLicense;
import com.clarkparsia.license.LicenseManager;
import com.clarkparsia.license.PublicLicenseParam;
import com.clarkparsia.license.VersionValidator;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import de.schlichtherle.license.LicenseContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public final class LicenseValidator
implements LicenseConstants {
    private final String mProduct;
    private final String mVersion;
    private final ImmutableMap<String, String> mFeatures;

    private LicenseValidator(String theProduct, String theVersion, ImmutableMap<String, String> theMap) {
        this.mProduct = theProduct;
        this.mVersion = theVersion;
        this.mFeatures = theMap;
    }

    public static LicenseValidator forProduct(String theProduct) {
        return new LicenseValidator(theProduct, null, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public LicenseValidator withVersion(String theVersion) {
        return new LicenseValidator(this.mProduct, theVersion, this.mFeatures);
    }

    public LicenseValidator usingFeature(String theKey, String theValue) {
        return new LicenseValidator(this.mProduct, this.mVersion, (ImmutableMap<String, String>)ImmutableMap.builder().putAll(this.mFeatures).put((Object)theKey, (Object)theValue).build());
    }

    public License validate(File theFile) throws InvalidLicenseException, ExpiredLicenseException, IOException {
        LicenseManager aManager = new LicenseManager(new PublicLicenseParam(this.mProduct));
        try (FileInputStream aInput = null;){
            boolean isValid;
            aInput = new FileInputStream(theFile);
            LicenseContent aContent = aManager.verify(ByteStreams.toByteArray((InputStream)aInput));
            if (aContent instanceof ExpiredLicenseContent) {
                String aType = (String)((ExpiredLicenseContent)aContent).getExtra().get("type");
                if (aType != null) {
                    if (aType.equals("Trial")) {
                        throw new ExpiredLicenseException("This trial license has expired.");
                    }
                    if (aType.equals("Subscription")) {
                        throw new ExpiredLicenseException("This subscription has ended as of " + aContent.getNotAfter().toString() + ".\nPlease contact sales to renew");
                    }
                }
                throw new ExpiredLicenseException("This license has expired.");
            }
            LicenseContentLicense aInfo = new LicenseContentLicense(aContent);
            if (this.mVersion != null && !(isValid = VersionValidator.forExpression(aInfo.getVersion()).isValid(this.mVersion))) {
                throw new InvalidLicenseVersionException(String.format("The license is for version %s, the current version of the product is %s.", aInfo.getVersion(), this.mVersion));
            }
            for (Map.Entry aEntry : this.mFeatures.entrySet()) {
                String aValue = aInfo.getData().get(aEntry.getKey());
                if (aValue == null) {
                    throw new InvalidLicenseException("The license is missing a required feature");
                }
                if (aValue.equals(aEntry.getValue())) continue;
                throw new InvalidLicenseException("The license has an invalid value for a required feature");
            }
            Object object = aInfo;
            return object;
        }
    }
}

