/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.license;

import com.clarkparsia.license.ExpiredLicenseContent;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseContentException;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.util.ObfuscatedString;
import de.schlichtherle.xml.GenericCertificate;

public class LicenseManager
extends de.schlichtherle.license.LicenseManager {
    private static final String EXC_LICENSE_HAS_EXPIRED = new ObfuscatedString(new long[]{1000558500458715757L, -6998261911041258483L, -5490039629745846648L, 3561172928787106880L}).toString();

    public LicenseManager(LicenseParam param) {
        super(param);
    }

    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getCertificate();
        if (null != certificate) {
            return (LicenseContent)certificate.getContent();
        }
        byte[] key = this.getLicenseKey();
        if (null == key) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        try {
            this.validate(content);
        }
        catch (LicenseContentException e) {
            if (e.getMessage().equals(EXC_LICENSE_HAS_EXPIRED)) {
                return ExpiredLicenseContent.fromLicenseContent(content, e);
            }
            throw e;
        }
        this.setCertificate(certificate);
        return content;
    }

    protected synchronized LicenseContent verify(byte[] key, LicenseNotary notary) throws Exception {
        GenericCertificate certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        LicenseContent content = (LicenseContent)certificate.getContent();
        try {
            this.validate(content);
        }
        catch (LicenseContentException e) {
            if (e.getMessage().equals(EXC_LICENSE_HAS_EXPIRED)) {
                return ExpiredLicenseContent.fromLicenseContent(content, e);
            }
            throw e;
        }
        return content;
    }
}

