/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.json;

import com.complexible.common.base.Options;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import com.stardog.stark.query.SelectQueryResultHandler;
import com.stardog.stark.query.io.InvalidQueryResults;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.SelectQueryResultParser;
import com.stardog.stark.query.io.json.SPARQLJSONConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;

public final class SPARQLJSONSelectResultParser
implements SelectQueryResultParser,
SPARQLJSONConstants {
    private static final JsonFactory JSON_FACTORY = JsonFactory.builder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES).disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES).disable(StreamWriteFeature.AUTO_CLOSE_TARGET).build();

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.JSON;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull SelectQueryResultHandler theHandler, @Nonnull Options theOptions) throws IOException {
        try {
            JsonParser jp = JSON_FACTORY.createParser(theStream);
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new InvalidQueryResults("Expected SPARQL Results JSON document to start with an Object", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
            }
            ArrayList<String> varsList = new ArrayList<String>();
            HashSet<BindingSet> bindings = new HashSet<BindingSet>();
            boolean varsFound = false;
            theHandler.start();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String baseStr = jp.currentName();
                if (baseStr.equals("head")) {
                    if (jp.nextToken() != JsonToken.START_OBJECT) {
                        throw new InvalidQueryResults("Did not find object under " + baseStr + " field", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                    }
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String headStr = jp.currentName();
                        if (headStr.equals("vars")) {
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new InvalidQueryResults("Expected variable labels to be an array", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                varsList.add(jp.getText());
                            }
                            theHandler.variables(varsList);
                            varsFound = true;
                            if (bindings.isEmpty()) continue;
                            for (BindingSet nextBinding : bindings) {
                                theHandler.handle((Object)nextBinding);
                                theHandler.end();
                            }
                            bindings.clear();
                            continue;
                        }
                        if (headStr.equals("link")) {
                            ArrayList<String> linksList = new ArrayList<String>();
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new InvalidQueryResults("Expected links to be an array", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                linksList.add(jp.getText());
                            }
                            theHandler.links(linksList);
                            continue;
                        }
                        throw new InvalidQueryResults("Found unexpected object in head field: " + headStr, (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                    }
                    continue;
                }
                if (baseStr.equals("results")) {
                    if (jp.nextToken() != JsonToken.START_OBJECT) {
                        throw new InvalidQueryResults("Found unexpected token in results object: " + jp.currentName(), (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                    }
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        if (jp.currentName().equals("bindings")) {
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new InvalidQueryResults("Found unexpected token in bindings object", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                BindingSets.Builder nextBindingSet = BindingSets.builder();
                                if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
                                    throw new InvalidQueryResults("Did not find object in bindings array: " + jp.currentName(), (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                                }
                                while (jp.nextToken() != JsonToken.END_OBJECT) {
                                    if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                        throw new InvalidQueryResults("Did not find binding name", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                                    }
                                    String bindingStr = jp.currentName();
                                    if (jp.nextToken() != JsonToken.START_OBJECT) {
                                        throw new InvalidQueryResults("Did not find object for binding value", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                                    }
                                    String lang = null;
                                    String type = null;
                                    String datatype = null;
                                    String value = null;
                                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                                        if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                            throw new InvalidQueryResults("Did not find value attribute under " + bindingStr + " field", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                                        }
                                        String fieldName = jp.currentName();
                                        jp.nextToken();
                                        if ("type".equals(fieldName)) {
                                            type = jp.getText();
                                            continue;
                                        }
                                        if ("xml:lang".equals(fieldName)) {
                                            lang = jp.getText();
                                            continue;
                                        }
                                        if ("datatype".equals(fieldName)) {
                                            datatype = jp.getText();
                                            continue;
                                        }
                                        if ("value".equals(fieldName)) {
                                            value = jp.getText();
                                            continue;
                                        }
                                        throw new InvalidQueryResults("Unexpected field name: " + fieldName, (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                                    }
                                    nextBindingSet.add(bindingStr, this.parseValue(type, value, lang, datatype));
                                }
                                if (!varsFound) {
                                    bindings.add(nextBindingSet.build());
                                    continue;
                                }
                                theHandler.handle((Object)nextBindingSet.build());
                            }
                            continue;
                        }
                        if (jp.currentName().equals("distinct") || jp.currentName().equals("ordered")) {
                            jp.nextToken();
                            continue;
                        }
                        throw new InvalidQueryResults("Found unexpected field in results: " + jp.currentName(), (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
                    }
                    continue;
                }
                if (baseStr.equals("boolean")) {
                    throw new InvalidQueryResults("Found boolean results when attempting to parse SPARQL Results JSON to tuple results");
                }
                throw new InvalidQueryResults("Found unexpected object in top level " + baseStr + " field", (long)jp.currentLocation().getLineNr(), (long)jp.currentLocation().getColumnNr());
            }
        }
        catch (JsonParseException e) {
            throw new InvalidQueryResults(e.getMessage(), (long)e.getLocation().getLineNr(), (long)e.getLocation().getColumnNr());
        }
        theHandler.end();
    }

    private Value parseValue(String type, String value, String language, String datatype) {
        BNode result = null;
        switch (type) {
            case "literal": 
            case "typed-literal": {
                if (language != null) {
                    result = Values.literal((String)value, (String)language);
                    break;
                }
                if (datatype != null) {
                    result = Values.literal((String)value, (IRI)Values.iri((String)datatype));
                    break;
                }
                result = Values.literal((String)value);
                break;
            }
            case "bnode": {
                result = Values.bnode((String)value);
                break;
            }
            case "uri": {
                result = Values.iri((String)value);
                break;
            }
            case "statement": 
            case "s": 
            case "p": 
            case "o": 
            case "g": {
                throw new UnsupportedOperationException("Statement not implemented");
            }
        }
        return result;
    }
}

