/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.json;

import com.complexible.common.base.Options;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.stardog.stark.query.BooleanQueryResultHandler;
import com.stardog.stark.query.io.BooleanQueryResultParser;
import com.stardog.stark.query.io.InvalidQueryResults;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.json.SPARQLJSONConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public final class SPARQLJSONBooleanResultParser
implements BooleanQueryResultParser,
SPARQLJSONConstants {
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.JSON_BOOLEAN;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull BooleanQueryResultHandler theHandler, @Nonnull Options theOptions) throws IOException {
        try {
            JsonParser jp = JSON_FACTORY.createParser(theStream);
            boolean result = false;
            if (jp.nextToken() != JsonToken.START_OBJECT) {
                throw new InvalidQueryResults("Expected SPARQL Results JSON document to start with an Object", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String baseStr = jp.getCurrentName();
                if (baseStr.equals("head")) {
                    if (jp.nextToken() != JsonToken.START_OBJECT) {
                        throw new InvalidQueryResults("Did not find object under " + baseStr + " field", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    while (jp.nextToken() != JsonToken.END_OBJECT) {
                        String headStr = jp.getCurrentName();
                        if (headStr.equals("vars")) {
                            throw new InvalidQueryResults("Found tuple results variables when attempting to parse SPARQL Results JSON to boolean result");
                        }
                        if (headStr.equals("link")) {
                            ArrayList<String> linksList = new ArrayList<String>();
                            if (jp.nextToken() != JsonToken.START_ARRAY) {
                                throw new InvalidQueryResults("Expected links to be an array", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                            }
                            while (jp.nextToken() != JsonToken.END_ARRAY) {
                                linksList.add(jp.getText());
                            }
                            theHandler.links(linksList);
                            continue;
                        }
                        throw new InvalidQueryResults("Found unexpected object in head field: " + headStr, (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                    }
                    continue;
                }
                if (baseStr.equals("results")) {
                    throw new InvalidQueryResults("Found tuple results bindings when attempting to parse SPARQL Results JSON to boolean result");
                }
                if (baseStr.equals("boolean")) {
                    jp.nextToken();
                    String aValue = jp.getText();
                    switch (aValue.toLowerCase()) {
                        case "true": {
                            result = true;
                            break;
                        }
                        case "false": {
                            result = false;
                            break;
                        }
                        default: {
                            throw new InvalidQueryResults(aValue + " is not a valid boolean value.", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
                        }
                    }
                    theHandler.handle(Boolean.valueOf(result));
                    continue;
                }
                throw new InvalidQueryResults("Found unexpected object in top level " + baseStr + " field", (long)jp.getCurrentLocation().getLineNr(), (long)jp.getCurrentLocation().getColumnNr());
            }
        }
        catch (JsonParseException e) {
            throw new InvalidQueryResults(e.getMessage(), (long)e.getLocation().getLineNr(), (long)e.getLocation().getColumnNr());
        }
        theHandler.end();
    }

    static {
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
    }
}

