/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.query.io.json;

import com.complexible.common.base.Options;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.google.common.base.Charsets;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.query.io.QueryResultFormat;
import com.stardog.stark.query.io.QueryResultFormats;
import com.stardog.stark.query.io.QueryResultWriter;
import com.stardog.stark.query.io.QueryResultWriterOptions;
import com.stardog.stark.query.io.ResultWritingFailed;
import com.stardog.stark.query.io.json.SPARQLJSONOptions;
import com.stardog.stark.vocabs.XSD;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractSPARQLJSONWriter<T>
implements QueryResultWriter<T> {
    private static final JsonFactory JSON_FACTORY = JsonFactory.builder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES).disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES).disable(StreamWriteFeature.AUTO_CLOSE_TARGET).build();
    protected final JsonGenerator jg;
    protected final Options mOptions;
    protected boolean firstTupleWritten = false;
    protected boolean documentOpen = false;
    protected boolean headerOpen = false;
    protected boolean headerComplete = false;
    protected boolean tupleVariablesFound = false;
    protected boolean linksFound = false;

    protected AbstractSPARQLJSONWriter(@Nonnull OutputStream theOutput, @Nonnull Options theOptions) {
        try {
            this.mOptions = theOptions;
            this.jg = JSON_FACTORY.createGenerator((Writer)new OutputStreamWriter(theOutput, Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void start() {
        if (!this.documentOpen) {
            this.documentOpen = true;
            this.headerOpen = false;
            this.headerComplete = false;
            this.tupleVariablesFound = false;
            this.firstTupleWritten = false;
            this.linksFound = false;
            if (this.mOptions.is(QueryResultWriterOptions.PRETTY_PRINT)) {
                DefaultIndenter indenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
                this.jg.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)indenter).withObjectIndenter((DefaultPrettyPrinter.Indenter)indenter));
            }
            try {
                if (this.mOptions.contains(SPARQLJSONOptions.JSONP_CALLBACK)) {
                    this.jg.writeRaw((String)this.mOptions.get(SPARQLJSONOptions.JSONP_CALLBACK));
                    this.jg.writeRaw("(");
                }
                this.jg.writeStartObject();
            }
            catch (IOException e) {
                throw new ResultWritingFailed(e.getMessage());
            }
        }
    }

    public void links(@Nonnull List<String> theLinks) {
        try {
            if (!this.documentOpen) {
                this.start();
            }
            if (!this.headerOpen) {
                this.startHeader();
            }
            this.jg.writeArrayFieldStart("link");
            for (String nextLink : theLinks) {
                this.jg.writeString(nextLink);
            }
            this.jg.writeEndArray();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
    }

    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) throws ResultWritingFailed {
    }

    public void end() {
        if (!this.documentOpen) {
            return;
        }
        try {
            this.jg.writeEndObject();
            if (this.mOptions.contains(SPARQLJSONOptions.JSONP_CALLBACK)) {
                this.jg.writeRaw(");");
            }
            this.jg.flush();
        }
        catch (IOException e) {
            throw new ResultWritingFailed((Throwable)e);
        }
        finally {
            this.documentOpen = false;
            this.headerOpen = false;
            this.headerComplete = false;
            this.tupleVariablesFound = false;
            this.firstTupleWritten = false;
            this.linksFound = false;
        }
    }

    protected void startHeader() {
        if (!this.documentOpen) {
            this.start();
        }
        if (!this.headerOpen) {
            try {
                this.writeHeaderFields();
                this.headerOpen = true;
            }
            catch (IOException e) {
                throw new ResultWritingFailed((Throwable)e);
            }
        }
    }

    protected void writeHeaderFields() throws IOException {
        this.jg.writeObjectFieldStart("head");
    }

    protected void endHeader() {
        if (!this.headerComplete) {
            try {
                this.jg.writeEndObject();
                if (this.tupleVariablesFound) {
                    this.jg.writeObjectFieldStart("results");
                    this.jg.writeArrayFieldStart("bindings");
                }
                this.headerComplete = true;
            }
            catch (IOException e) {
                throw new ResultWritingFailed((Throwable)e);
            }
        }
    }

    protected void writeValue(@Nonnull Value value) throws IOException {
        this.jg.writeStartObject();
        if (value instanceof IRI) {
            this.jg.writeStringField("type", "uri");
            this.jg.writeStringField("value", ((IRI)value).toString());
        } else if (value instanceof BNode) {
            this.jg.writeStringField("type", "bnode");
            this.jg.writeStringField("value", ((BNode)value).id());
        } else if (value instanceof Statement) {
            Statement statement = (Statement)value;
            this.jg.writeStringField("type", "statement");
            this.jg.writeFieldName("s");
            this.writeValue((Value)statement.subject());
            this.jg.writeFieldName("p");
            this.writeValue((Value)statement.predicate());
            this.jg.writeFieldName("o");
            this.writeValue(statement.object());
            if (!Values.isDefaultGraph((Resource)statement.context())) {
                this.jg.writeFieldName("g");
                this.writeValue((Value)statement.context());
            }
        } else if (value instanceof Literal) {
            Literal lit = (Literal)value;
            if (Literal.isLanguageLiteral((Literal)lit)) {
                this.jg.writeObjectField("xml:lang", lit.lang().orElse(null));
            } else {
                boolean ignoreDatatype;
                IRI datatype = lit.datatypeIRI();
                boolean bl = ignoreDatatype = datatype.equals((Object)XSD.STRING) && this.mOptions.is(WriterOptions.XSD_STRING_TO_PLAIN_LITERAL);
                if (!ignoreDatatype) {
                    this.jg.writeObjectField("datatype", (Object)lit.datatypeIRI().toString());
                }
            }
            this.jg.writeObjectField("type", (Object)"literal");
            this.jg.writeObjectField("value", (Object)lit.label());
        } else {
            throw new ResultWritingFailed("Unknown Value object type: " + String.valueOf(value.getClass()));
        }
        this.jg.writeEndObject();
    }

    @Nonnull
    public QueryResultFormat format() {
        return QueryResultFormats.JSON;
    }
}

