/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning.hints;

import com.complexible.stardog.query.hints.BaseHint;
import com.complexible.stardog.query.hints.Hint;
import com.complexible.stardog.query.hints.InvalidHintValue;
import com.complexible.stardog.query.hints.RegisteredHint;
import com.complexible.stardog.query.hints.Toggle;
import com.complexible.stardog.reasoning.RewritingStrategy;

public class ReasoningHints {
    public static final Rewriting REWRITING_STRATEGY = new Rewriting();
    public static final PushReasoning PUSH_REASONING = new PushReasoning();
    public static final ReasoningDistinct REASONING_DISTINCT = new ReasoningDistinct();
    public static final ReduceRedundancy REASONING_PRUNE_REDUNDANCY = new ReduceRedundancy();

    public static final class Rewriting
    extends RegisteredHint.Abstract<RewritingStrategy> {
        public static final String NAME = "reasoning.rewriting";

        public Rewriting() {
            super(NAME, "Specifies how query rewriting should be done:\nper_scope: all triple patterns as a group (default)\nper_pattern: each triple pattern individually (results in smaller rewritings in some cases)");
        }

        public Hint<RewritingStrategy> create(String value) throws InvalidHintValue {
            return new BaseHint(NAME, (Object)((RewritingStrategy)Rewriting.parseEnum((String)NAME, (String)value, (Enum[])RewritingStrategy.values())));
        }
    }

    public static final class PushReasoning
    extends RegisteredHint.Abstract<Strategy> {
        public static final String NAME = "push.reasoning";

        public PushReasoning() {
            super(NAME, "Specifies how the optimizer should try to patterns under reasoning operators like '?s rdf:type ?type':\naggressive: always push the one which looks the most selective\ndefault: the optimizer will decide based on any available criteria\noff: the optimization is off");
        }

        public Hint<Strategy> create(String value) throws InvalidHintValue {
            return new BaseHint(NAME, (Object)((Strategy)PushReasoning.parseEnum((String)NAME, (String)value, (Enum[])Strategy.values())));
        }

        public static enum Strategy {
            AGGRESSIVE,
            DEFAULT,
            OFF;

        }
    }

    public static final class ReasoningDistinct
    extends RegisteredHint.Abstract<Toggle> {
        public static final String NAME = "reasoning.distinct";

        public ReasoningDistinct() {
            super(NAME, "If off, the reasoner will not place a DISTINCT operator on top of the query plan");
        }

        public Hint<Toggle> create(String value) throws InvalidHintValue {
            return new BaseHint(NAME, (Object)((Toggle)ReasoningDistinct.parseEnum((String)NAME, (String)value, (Enum[])Toggle.values())));
        }

        public boolean retainedAfterTermReplacement() {
            return true;
        }
    }

    public static final class ReduceRedundancy
    extends RegisteredHint.Abstract<Toggle> {
        public static final String NAME = "reasoning.redundancy.prune";

        public ReduceRedundancy() {
            super(NAME, "If off, the reasoner will not try to reduce the rewritten query by pruning patterns joined multiple times");
        }

        public Hint<Toggle> create(String value) throws InvalidHintValue {
            return new BaseHint(NAME, (Object)((Toggle)ReduceRedundancy.parseEnum((String)NAME, (String)value, (Enum[])Toggle.values())));
        }

        public boolean retainedAfterTermReplacement() {
            return true;
        }
    }
}

