/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.stardog.metadata.ByteIO;
import com.complexible.stardog.metadata.GraphIO;
import com.complexible.stardog.metadata.TextIO;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;

public final class SchemaGraph {
    private final String schema;
    private final IRI graph;
    private static final Splitter mSplitter = Splitter.on((char)'=').limit(2);
    public static final TextIO<SchemaGraph> TEXT_IO = new TextIO<SchemaGraph>(){

        public SchemaGraph _read(String theValue) {
            String[] aStr = (String[])Iterables.toArray((Iterable)mSplitter.split((CharSequence)theValue), String.class);
            if (aStr.length != 2) {
                throw new IllegalArgumentException("Not a valid prefix definition: " + theValue);
            }
            return new SchemaGraph(aStr[0], Values.iri((String)aStr[1]));
        }

        public String _write(SchemaGraph theValue) {
            return theValue.getSchema() + "=" + String.valueOf(theValue.getGraph());
        }
    };
    public static final GraphIO<SchemaGraph> GRAPH_IO = new GraphIO<SchemaGraph>(){

        public SchemaGraph read(Value theValue, Set<Statement> theGraph) {
            Literal aLiteral = (Literal)theValue;
            String aSchema = aLiteral.label();
            IRI aGraph = aLiteral.datatypeIRI();
            return new SchemaGraph(aSchema, aGraph);
        }

        public Value _write(SchemaGraph theValue, Set<Statement> theGraph, Supplier<IRI> theValueGenerator) {
            return Values.literal((String)theValue.getSchema(), (IRI)theValue.getGraph());
        }
    };
    public static final ByteIO<SchemaGraph> BYTE_IO = new ByteIO<SchemaGraph>(){

        public SchemaGraph read(ByteReader theReader) throws IOException {
            return new SchemaGraph(theReader.readString(), Values.iri((String)theReader.readString()));
        }

        public void write(SchemaGraph theValue, ByteWriter theByteWriter) throws IOException {
            theByteWriter.writeString(theValue.getSchema());
            theByteWriter.writeString(theValue.getGraph().toString());
        }
    };

    public SchemaGraph(String theSchema, IRI theGraph) {
        this.schema = theSchema;
        this.graph = theGraph;
    }

    public String getSchema() {
        return this.schema;
    }

    public IRI getGraph() {
        return this.graph;
    }
}

