/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.clarkparsia.pellet.api.io.OntologyReaderOptions;
import com.clarkparsia.pellet.api.io.OntologyWriterOptions;
import com.clarkparsia.pellet.api.kb.PelletReasoningOptions;
import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.api.term.entity.Value;
import com.clarkparsia.pellet.rdf.RDFAxiomReaders;
import com.clarkparsia.pellet.rdf.RDFAxiomWriter;
import com.clarkparsia.pellet.rdf.RDFAxiomWriters;
import com.clarkparsia.pellet.stark.StarkGraphInput;
import com.clarkparsia.pellet.stark.StarkRDFFactory;
import com.clarkparsia.pellet.stark.StarkRDFOutputs;
import com.clarkparsia.pellet.util.progress.SilentProgressMonitor;
import com.complexible.common.base.Options;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.stardog.stark.Axioms;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.OWL;
import com.stardog.stark.Statement;
import com.stardog.stark.vocabs.RDF;
import com.stardog.stark.vocabs.RDFS;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class ReasoningUtils {
    private static final StarkRDFFactory FACTORY = StarkRDFFactory.INSTANCE;
    private static final Set<IRI> SYNTAX_TYPES = Sets.newHashSet((Object[])new IRI[]{OWL.CLASS, OWL.OBJECTPROPERTY, OWL.DATATYPEPROPERTY, OWL.THING, OWL.NAMED_INDIVIDUAL, RDFS.DATATYPE});

    private ReasoningUtils() {
        throw new AssertionError();
    }

    public static Value convertToValue(com.stardog.stark.Value theValue) {
        if (theValue instanceof IRI) {
            return TermFactory.namedIndividual(theValue.toString());
        }
        if (theValue instanceof BNode) {
            return TermFactory.anonymousIndividual(theValue.toString());
        }
        Literal aLiteral = (Literal)theValue;
        String aLabel = aLiteral.label();
        if (Literal.isLanguageLiteral((Literal)aLiteral)) {
            return TermFactory.literal(aLabel, (String)aLiteral.lang().get());
        }
        IRI aDatatype = aLiteral.datatypeIRI();
        if (aLiteral.datatype() != Datatype.STRING) {
            return TermFactory.literal(aLabel, TermFactory.namedDatatype(aDatatype.toString()));
        }
        return TermFactory.literal(aLabel);
    }

    public static Set<Axiom> convertToAxioms(Statement ... stmts) {
        return ReasoningUtils.convertToAxioms((Iterator<Statement>)Iterators.forArray((Object[])stmts));
    }

    public static Set<Axiom> convertToAxioms(Iterable<Statement> stmts) {
        return ReasoningUtils.convertToAxioms(stmts, OntologyReaderOptions.Scope.ALL);
    }

    public static Set<Axiom> convertToAxioms(Iterable<Statement> stmts, OntologyReaderOptions.Scope scope) {
        Options options = Options.of(OntologyReaderOptions.SCOPE, (Object)((Object)scope), PelletReasoningOptions.PROGRESS_MONITOR, (Object)new SilentProgressMonitor());
        Set aGraph = stmts instanceof Set ? (Set)stmts : Sets.newHashSet(stmts);
        return RDFAxiomReaders.read(new StarkGraphInput(FACTORY, aGraph), options);
    }

    public static Set<Axiom> convertToAxioms(Iterator<Statement> stmts) {
        return ReasoningUtils.convertToAxioms(Sets.newHashSet(stmts));
    }

    public static Axiom convertToAxiom(com.stardog.stark.Axiom theExpression) {
        return (Axiom)Iterables.getOnlyElement(ReasoningUtils.convertToAxioms(theExpression.iterator()));
    }

    public static Set<Statement> convertToStatements(Axiom ... axioms) {
        return ReasoningUtils.convertToStatements(Arrays.asList(axioms));
    }

    public static Set<Statement> convertToStatements(Iterator<Axiom> axioms) {
        return ReasoningUtils.convertToStatements(() -> axioms);
    }

    public static Set<Statement> convertToStatements(Iterable<Axiom> axioms) {
        RDFAxiomWriter writer = ReasoningUtils.createStmtWriter();
        return ReasoningUtils.convertToStatements(writer, axioms);
    }

    private static Set<Statement> convertToStatements(RDFAxiomWriter writer, Iterable<Axiom> axioms) {
        HashSet aStmts = Sets.newHashSet();
        writer.write(axioms, StarkRDFOutputs.forCollection(aStmts, FACTORY));
        return aStmts;
    }

    private static RDFAxiomWriter createStmtWriter() {
        Options options = Options.of(OntologyWriterOptions.DECLARATION_HANDLING, (Object)((Object)OntologyWriterOptions.DeclarationHandling.WRITE_ASSERTED), PelletReasoningOptions.PROGRESS_MONITOR, (Object)new SilentProgressMonitor());
        return RDFAxiomWriters.create(options);
    }

    public static com.stardog.stark.Axiom convertToExpression(Axiom theAxiom) {
        Set<Statement> aGraph = ReasoningUtils.convertToStatements(theAxiom);
        return Axioms.fromStatements(aGraph);
    }

    public static Set<com.stardog.stark.Axiom> convertToExpressions(Iterable<Axiom> axioms) {
        RDFAxiomWriter aWriter = ReasoningUtils.createStmtWriter();
        HashSet aExpr = Sets.newHashSet();
        for (Axiom aAxiom : axioms) {
            Set<Statement> aGraph = ReasoningUtils.convertToStatements(aWriter, Collections.singleton(aAxiom));
            aExpr.add(Axioms.fromStatements(aGraph));
        }
        return aExpr;
    }

    public static Set<com.stardog.stark.Axiom> convertToExpressions(Set<Statement> theStatements) {
        return ReasoningUtils.convertToExpressions(ReasoningUtils.convertToAxioms(theStatements));
    }

    public static Iterable<Statement> filterSyntaxTypes(Iterable<Statement> stmts) {
        return Iterables.filter(stmts, theStmt -> !theStmt.predicate().equals((Object)RDF.TYPE) || !SYNTAX_TYPES.contains(theStmt.object()));
    }
}

