/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.complexible.common.base.Duration;
import com.complexible.stardog.db.DatabaseOptions;
import com.complexible.stardog.index.EqualityReasoningLevel;
import com.complexible.stardog.metadata.ByteIO;
import com.complexible.stardog.metadata.ConfigProperty;
import com.complexible.stardog.metadata.GraphIO;
import com.complexible.stardog.metadata.MetaProperty;
import com.complexible.stardog.metadata.MetaPropertyProvider;
import com.complexible.stardog.metadata.OptionsCategory;
import com.complexible.stardog.metadata.TextIO;
import com.complexible.stardog.reasoning.RewritingStrategy;
import com.complexible.stardog.reasoning.SchemaGraph;
import com.complexible.stardog.reasoning.api.ReasoningType;
import com.google.common.collect.ImmutableSet;
import com.stardog.stark.IRI;
import com.stardog.stark.Values;
import java.util.Collection;
import java.util.Set;

public final class ReasoningOptions
implements MetaPropertyProvider {
    public static final IRI DEFAULT_SCHEMA_GRAPH_IRI = Values.iri((String)"tag:stardog:api:context:schema");
    private static final String OPTION_SCHEMA = "reasoning.schema.graphs";
    private static final String OPTION_PUNNING = "reasoning.punning.enabled";
    private static final String OPTION_CONSISTENCY = "reasoning.consistency.automatic";
    private static final String OPTION_SCHEMAS = "reasoning.schemas";
    private static final String OPTION_SCHEMAS_MEMORY_COUNT = "reasoning.schemas.memory.count";
    private static final String OPTION_SCHEMA_TIMEOUT = "reasoning.schema.timeout";
    private static final String OPTION_REASONING_TYPE = "reasoning.type";
    private static final String OPTION_APPROXIMATE = "reasoning.approximate";
    private static final String OPTION_VIRTUAL = "reasoning.virtual.graph.enabled";
    private static final String OPTION_EAGER_CLASSIFY = "reasoning.classify.eager";
    private static final String OPTION_OPTIMIZE_REASONING = "optimize.reasoning";
    private static final String OPTION_PRECOMPUTE_NON_EMPTY_PREDICATES = "reasoning.precompute.non_empty.predicates";
    private static final String OPTION_DOMAIN_RANGE_OPTIMIZATION = "reasoning.domain.range.rule.optimization";
    private static final String OPTION_REWRITING_STRATEGY = "reasoning.rewriting";
    private static final String OPTION_STRIDE = "reasoning.stride";
    public static final ConfigProperty<EqualityReasoningLevel> EQUALITY_REASONING = DatabaseOptions.EQUALITY_REASONING;
    public static final ConfigProperty<Collection<IRI>> SCHEMA_GRAPHS = (ConfigProperty)MetaProperty.config((String)"reasoning.schema.graphs", IRI.class, Set.of(DEFAULT_SCHEMA_GRAPH_IRI)).database().readable().writableWhileOnline().creatable().category(OptionsCategory.REASONING).label("Schema Graphs").description("Determines which, if any, named graph or graphs contains the schema (ontology, \"TBox\") part of the data. The legal value is a comma-separated list of named graph identifiers. The default value is tag:stardog:api:context:schema.").nonsecure().build();
    public static final ConfigProperty<Collection<SchemaGraph>> SCHEMAS = (ConfigProperty)MetaProperty.config((String)"reasoning.schemas", SchemaGraph.class, (Collection)ImmutableSet.of()).database().readable().creatable().writableWhileOnline().category(OptionsCategory.REASONING).label("Reasoning Schemas").description("Option to specify the schemas and the named graphs that constitute each schema. The value is a comma-separated collection of schema=IRI pairs. There should be one pair for each named graph in a schema. The graphs for the default schema are set via the reasoning.schema.graphs option.").textIO((TextIO)new TextIO.CollectionIO(SchemaGraph.TEXT_IO, false, false)).graphIO((GraphIO)new GraphIO.CollectionIO(SchemaGraph.GRAPH_IO, false)).byteIO(ByteIO.set(SchemaGraph.BYTE_IO)).nonsecure().build();
    public static final ConfigProperty<Boolean> ENABLE_SCHEMA_VERSIONING = (ConfigProperty)MetaProperty.config((String)"reasoning.schema.versioning.enabled", (Object)false).database().readable().creatable().writable().category(OptionsCategory.REASONING).label("Track Schema Versions").description("Determines if the reasoner will track changes to triples in schema graphs. Enabling this option allows reasoner to invalidate its state only when one of the schema graphs is updated. If this option is not enabled the reasoner will invalidate its state whenever any named graph is updated which is wasteful because the exact same state will be recomputed. When this option is enabled schema graphs have to be regular named graph IRIs and wildcard graphs cannot be used as schema graphs.").build();
    public static final ConfigProperty<Integer> SCHEMAS_MEMORY_COUNT = (ConfigProperty)MetaProperty.config((String)"reasoning.schemas.memory.count", (Object)5).database().readable().creatable().writable().category(OptionsCategory.REASONING).label("Reasoning Schema Memory Count").description("Option to specify the number of schemas to keep in memory. There can be more schemas defined in the database but only this many schemas will be kept in memory and other schemas will be pulled into memory as queries are getting answered. If this limit is too high, the amount of memory used for schemas will increase and might cause memory problems. If it is too low then answering reasoning queries might slow down.").build();
    public static final ConfigProperty<Boolean> PUNNING_ENABLED = (ConfigProperty)MetaProperty.config((String)"reasoning.punning.enabled", (Object)false).database().readable().creatable().writable().category(OptionsCategory.REASONING).label("Punning").description("Enables punning; the ability for an IRI to represent both a class and an individual.").build();
    public static final ConfigProperty<Boolean> CONSISTENCY_AUTOMATIC = (ConfigProperty)MetaProperty.config((String)"reasoning.consistency.automatic", (Object)false).database().readable().writable().creatable().category(OptionsCategory.REASONING).label("Automatic Consistency").description("Enables automatic consistency checking as part of every query performed with reasoning enabled. If the underlying database did not change since the last consistency check, the check will not be performed.").build();
    public static final ConfigProperty<Duration> SCHEMA_REASONING_TIMEOUT = (ConfigProperty)MetaProperty.config((String)"reasoning.schema.timeout", (Object)Duration.valueOf((String)"60s")).database().readable().creatable().writableWhileOnline().category(OptionsCategory.REASONING).label("Schema Reasoning Timeout").description("Timeout for schema reasoning. If schema reasoning cannot be completed in the specified time then only RDFS reasoning will be performed for the schema which might yield incomplete answers for the schema queries. The timeout values specified as test be a positive integer followed by either letter 'h' (for hours), letter 'm' (for minutes), letter 's' (for seconds), or letters 'ms' (for milliseconds). Examples: '1h' for 1 hour, '5m' for 5 minutes, '90s' for 90 seconds, '500ms' for 500 milliseconds.").build();
    public static final ConfigProperty<ReasoningType> REASONING_TYPE = (ConfigProperty)MetaProperty.config((String)"reasoning.type", (Object)((Object)ReasoningType.SL)).creatable().readable().writable().database().category(OptionsCategory.REASONING).label("Reasoning Type").description("Specifies the reasoning type associated with the database, most corresponding to the OWL Profiles of the same name. The following reasoning types are available: RDFS (OWL 2 axioms allowed in RDF Schema), QL (OWL 2 QL axioms), RL (OWL 2 RL axioms), EL (OWL 2 EL axioms), SL (a combination of RDFS, QL, RL and EL axioms + user-defined rules) and NONE (disables reasoning). Any axiom outside the selected type will be ignored by the reasoner. This option has no effect if reasoning.stride is enabled. Support for DL reasoning type has been removed in version 9.0 and cannot be used ianymore.").build();
    public static final ConfigProperty<Boolean> APPROXIMATE = (ConfigProperty)MetaProperty.config((String)"reasoning.approximate", (Object)false).creatable().readable().writable().database().category(OptionsCategory.REASONING).label("Approximate").description("Enables approximate reasoning. With this flag enabled Stardog will approximate an axiom that is outside the profile Stardog supports and normally ignored. For example, an equivalent class axiom might be split into two subclass axioms and only one subclass axiom is used.").build();
    public static final ConfigProperty<Boolean> VIRTUAL_GRAPH = (ConfigProperty)MetaProperty.config((String)"reasoning.virtual.graph.enabled", (Object)true).creatable().readable().writableWhileOnline().database().category(OptionsCategory.REASONING).label("Virtual Graph").description("Flag to enable reasoning over virtual graphs and SERVICE clauses.").build();
    public static final ConfigProperty<Boolean> EAGER_CLASSIFY = (ConfigProperty)MetaProperty.config((String)"reasoning.classify.eager", (Object)true).creatable().readable().writable().database().category(OptionsCategory.REASONING).label("Eagerly Classify").description("Perform schema classification eagerly when the schema is loaded. Classifying eagerly ensures subclass and equivalence queries between named classes can be answered with a simple lookup. However, if the schema is changing frequently then this option can be turned off so classification is performed only if necessary.").build();
    public static final ConfigProperty<Boolean> PRECOMPUTE_NON_EMPTY_TERMS = (ConfigProperty)MetaProperty.config((String)"reasoning.precompute.non_empty.predicates", (Object)true).creatable().readable().writableWhileOnline().database().category(OptionsCategory.REASONING).label("Precompute non-empty predicates").description("If true, Stardog will pre-compute class and property names which have assertions in the data. That can speed-up reasoning but may slow things down when data changes often.").build();
    public static final ConfigProperty<Boolean> DOMAIN_RANGE_OPTIMIZATION = (ConfigProperty)MetaProperty.config((String)"reasoning.domain.range.rule.optimization", (Object)true).creatable().readable().writable().database().category(OptionsCategory.REASONING).label("Domain/Range Optimization").description("Enables optimization to remove redundant type assertions from queries or rule bodies when types can be inferred from schema.org domainIncludes/rangeIncludes or rdfs:domain/rdfs:range declarations on properties. This can improve reasoning performance by reducing the number of triple patterns in a query or a rule body. WARNING: This option is not conformant with RDFS and OWL semantics because schema.org vocabulary has no semantic interpretation. Enabling this option may cause reasoning queries to return more results if the data does not satisfy the domain/range declarations. If the data conforms to the domain/range declarations then the query results will not change due to this optimization. To ensure this, domain optimization only applies when a property has exactly one domain, and range optimization only applies when a property has exactly one range. ").build();
    public static final ConfigProperty<RewritingStrategy> REWRITING_STRATEGY = (ConfigProperty)MetaProperty.config((String)"reasoning.rewriting", (Object)((Object)RewritingStrategy.PER_SCOPE)).creatable().readable().writable().database().category(OptionsCategory.REASONING).label("Rewriting query patterns together or individually").description("Allows one to choose how query patterns are rewritten for reasoning: as a whole (per scope) or individually (per pattern).").build();
    public static final ConfigProperty<Boolean> OPTIMIZE = (ConfigProperty)MetaProperty.config((String)"optimize.reasoning", (Object)true).creatable().readable().writableWhileOnline().database().build();
    public static final ConfigProperty<Boolean> STRIDE = (ConfigProperty)MetaProperty.config((String)"reasoning.stride", (Object)false).creatable().readable().writable().database().category(OptionsCategory.REASONING).label("Use the Stride reasoner (alpha)").description("If enabled, Stardog will use the new Stride reasoner based on Datalog. Some functionality could be unstable or missing.").build();
    public static final ConfigProperty<Integer> REWRITE_LIMIT = (ConfigProperty)MetaProperty.config((String)"reasoning.rewrite.limit", (Object)10000).creatable().readable().writableWhileOnline().database().category(OptionsCategory.REASONING).label("Rewriting limit for the Stride reasoner").description("The maximum number of triple patterns that is allowed in a rewritten reasoning query. If the number of triple patterns in the rewritten query exceeds this limit the rewriting will be canceled and query execution will fail.").build();

    private ReasoningOptions() {
        throw new AssertionError();
    }
}

