/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.complexible.common.base.Pair;
import com.complexible.stardog.reasoning.ImmutableProof;
import com.complexible.stardog.reasoning.MutableProof;
import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ProofType;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.stardog.stark.IRI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Proofs {
    private Proofs() {
        throw new AssertionError();
    }

    public static Proof forExpressions(com.stardog.stark.Axiom theExpression, ProofType theStatus, Iterable<com.stardog.stark.Axiom> theExpressions) {
        ArrayList aNodes = Lists.newArrayList();
        ImmutableList noChildren = ImmutableList.of();
        for (com.stardog.stark.Axiom aExpr : theExpressions) {
            aNodes.add(Proofs.newProof(aExpr, ProofType.ASSERTED, (Iterable<Proof>)noChildren));
        }
        return Proofs.newProof(theExpression, theStatus, aNodes);
    }

    public static Proof newProof(com.stardog.stark.Axiom theExpression, ProofType theStatus) {
        return Proofs.newProof(theExpression, theStatus, (Iterable<Proof>)ImmutableList.of());
    }

    public static Proof newProof(com.stardog.stark.Axiom theExpression, ProofType theStatus, Iterable<Proof> theChildren) {
        return new ImmutableProof(theExpression, theStatus, theChildren, (Iterable<IRI>)ImmutableSet.of(), null);
    }

    public static Proof newProof(com.stardog.stark.Axiom theExpression, ProofType theStatus, Iterable<Proof> theChildren, Iterable<IRI> theNamedGraphs, Proof theAlternate) {
        return new ImmutableProof(theExpression, theStatus, theChildren, theNamedGraphs, theAlternate);
    }

    public static List<MutableProof> merge(Iterable<? extends Proof> theProofs) {
        ArrayList aList = Lists.newArrayList();
        MutableProof aMutableProof = null;
        for (Proof proof : theProofs) {
            MutableProof aNewProof = Proofs.mutable(proof);
            if (aMutableProof != null && Proofs.merge(aMutableProof, aNewProof)) continue;
            aMutableProof = aNewProof;
            aList.add(aMutableProof);
        }
        return aList;
    }

    public static MutableProof mutable(Proof theProof) {
        if (theProof instanceof MutableProof) {
            return (MutableProof)theProof;
        }
        return Proofs.copy(theProof);
    }

    public static MutableProof copy(Proof theProof) {
        MutableProof aMutable = new MutableProof(theProof.getExpression(), theProof.getType());
        if (theProof.hasAlternate()) {
            aMutable.setAlternate(Proofs.mutable(theProof.getAlternate()));
        }
        for (IRI aNamedGraph : theProof.getNamedGraphs()) {
            aMutable.addNamedGraph(aNamedGraph);
        }
        for (Proof aChild : theProof.getChildren()) {
            aMutable.addChild(Proofs.mutable(aChild));
        }
        return aMutable;
    }

    private static boolean merge(MutableProof theResult, MutableProof theProof) {
        if (Objects.equal((Object)theResult.getAxiom(), (Object)theProof.getAxiom())) {
            MutableProof theMergeTarget = theResult;
            while (!Proofs.mergeProofs(theMergeTarget.getMutableChildren(), theProof.getMutableChildren())) {
                if (theMergeTarget.hasAlternate()) {
                    theMergeTarget = theMergeTarget.getAlternate();
                    continue;
                }
                Proofs.setAlternate(theMergeTarget, theProof);
                break;
            }
            return true;
        }
        return false;
    }

    private static void setAlternate(MutableProof theProof, Proof theAlternate) {
        MutableProof aProof = theProof;
        while (aProof.getAlternate() != null) {
            aProof = aProof.getAlternate();
        }
        aProof.setAlternate(Proofs.mutable(theAlternate));
    }

    private static boolean mergeProofs(Iterable<MutableProof> aActual, Iterable<MutableProof> aExpected) {
        ArrayList aExpectedChildren = Lists.newArrayList(aExpected);
        ArrayList aMergePairs = Lists.newArrayList();
        if (Iterables.isEmpty(aActual) && !aExpectedChildren.isEmpty()) {
            return false;
        }
        for (MutableProof aActualChild : aActual) {
            Axiom aActualAxiom = aActualChild.getAxiom();
            Iterator i = aExpectedChildren.iterator();
            boolean aMerged = false;
            while (i.hasNext()) {
                MutableProof aExpectedChild = (MutableProof)i.next();
                if (!Objects.equal((Object)aActualAxiom, (Object)aExpectedChild.getAxiom())) continue;
                aMergePairs.add(Pair.create((Object)aActualChild, (Object)aExpectedChild));
                i.remove();
                aMerged = true;
                break;
            }
            if (aMerged) continue;
            return false;
        }
        for (Pair aMergePair : aMergePairs) {
            Proofs.merge((MutableProof)aMergePair.first, (MutableProof)aMergePair.second);
        }
        return true;
    }

    public static int countDistinctProofs(Proof theProof) {
        int aCount = 1;
        for (Proof aChild : theProof.getChildren()) {
            aCount *= Proofs.countDistinctProofs(aChild);
        }
        if (theProof.hasAlternate()) {
            aCount += Proofs.countDistinctProofs(theProof.getAlternate());
        }
        return aCount;
    }

    public static List<Proof> getAlternateList(Proof theProof) {
        ArrayList aResult = Lists.newArrayList();
        while (theProof.hasAlternate()) {
            aResult.add(theProof);
            theProof = theProof.getAlternate();
        }
        aResult.add(theProof);
        return aResult;
    }
}

