/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.complexible.common.io.block.BlockSpec;
import com.complexible.common.io.block.BlockWriter;
import com.complexible.common.io.block.TextBlockWriter;
import com.complexible.stardog.reasoning.ExpressionWriter;
import com.complexible.stardog.reasoning.Proof;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;

public final class ProofWriter {
    private static final String NEWLINE = StandardSystemProperty.LINE_SEPARATOR.value();
    private StringWriter mStringWriter;
    private BlockWriter mBlockWriter;
    private ExpressionWriter mExpressionWriter;

    public static String toString(Proof theProof) {
        return ProofWriter.toString((Iterable<Namespace>)Namespaces.DEFAULT, theProof);
    }

    public static String toString(Iterable<Namespace> theNamespaces, Proof theProof) {
        return new ProofWriter(theNamespaces).write(theProof).toString();
    }

    public ProofWriter() {
        this((Iterable<Namespace>)Namespaces.DEFAULT);
    }

    public ProofWriter(Iterable<Namespace> theNamespaces) {
        this.mExpressionWriter = new ExpressionWriter(theNamespaces);
        this.mStringWriter = new StringWriter();
        this.mBlockWriter = new TextBlockWriter((Writer)this.mStringWriter);
    }

    public ProofWriter write(Proof theProof) {
        this.appendProof(theProof, 0, 0);
        return this;
    }

    private void appendProof(Proof theNode, int theID, int theIndex) {
        if (theNode.hasAlternate() || theIndex > 0) {
            if (theIndex == 0) {
                ++theID;
            }
            this.mBlockWriter.print(theID);
            this.mBlockWriter.print(".");
            this.mBlockWriter.print(++theIndex);
            this.mBlockWriter.print(") ");
        }
        this.mBlockWriter.print(theNode.getType().toString());
        this.mBlockWriter.printSpace();
        if (theNode.getExpression() != null && theNode.getExpression().iterator().hasNext()) {
            Object aExprStr = this.mExpressionWriter.reset().write((Iterable<Statement>)theNode.getExpression()).toString();
            if (!theNode.getNamedGraphs().isEmpty()) {
                aExprStr = ((String)aExprStr).trim() + " " + this.formatNamedGraphs(theNode);
            }
            this.mBlockWriter.beginBlock();
            for (String aLine : Splitter.on((String)NEWLINE).omitEmptyStrings().split((CharSequence)aExprStr)) {
                this.mBlockWriter.println(aLine);
            }
            this.mBlockWriter.endBlock();
        } else {
            this.mBlockWriter.println();
        }
        if (theNode.hasChildren()) {
            this.mBlockWriter.beginBlock(BlockSpec.INDENTED);
            for (Proof aChild : theNode.getChildren()) {
                this.appendProof(aChild, theID, 0);
            }
            this.mBlockWriter.endBlock();
        }
        if (theNode.hasAlternate()) {
            this.appendProof(theNode.getAlternate(), theID, theIndex);
        }
    }

    private String formatNamedGraphs(Proof theProof) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<IRI> i = theProof.getNamedGraphs().iterator();
        sb.append(this.mExpressionWriter.formatURI(i.next().toString()));
        while (i.hasNext()) {
            sb.append(", ");
            sb.append(this.mExpressionWriter.formatURI(i.next().toString()));
        }
        sb.append("]");
        return sb.toString();
    }

    public ProofWriter reset() {
        this.mStringWriter.getBuffer().setLength(0);
        return this;
    }

    public String toString() {
        return this.mStringWriter.toString();
    }
}

