/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.complexible.stardog.reasoning.AbstractProof;
import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ProofType;
import com.complexible.stardog.reasoning.ReasoningUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.stardog.stark.IRI;
import com.stardog.stark.Statement;
import java.util.Set;

final class ImmutableProof
extends AbstractProof {
    private final Iterable<Proof> mChildren;
    private final boolean hasChildren;
    private final com.stardog.stark.Axiom mExpression;
    private final Axiom mAxiom;
    private final ProofType mType;
    private final Set<IRI> mNamedGraphs;
    private final Proof mAlternate;

    public ImmutableProof(com.stardog.stark.Axiom theExpression, ProofType theType, Iterable<Proof> theChildren, Iterable<IRI> theNamedGraphs, Proof theAlternate) {
        this.mChildren = theChildren;
        this.hasChildren = !Iterables.isEmpty(this.mChildren);
        this.mExpression = theExpression;
        this.mAxiom = this.mExpression == null ? null : (Axiom)Iterables.getFirst(ReasoningUtils.convertToAxioms((Iterable<Statement>)this.mExpression), null);
        this.mType = theType;
        this.mNamedGraphs = ImmutableSet.copyOf(theNamedGraphs);
        this.mAlternate = theAlternate;
    }

    @Override
    public com.stardog.stark.Axiom getExpression() {
        return this.mExpression;
    }

    @Override
    public ProofType getType() {
        return this.mType;
    }

    @Override
    public Iterable<Proof> getChildren() {
        return this.mChildren;
    }

    @Override
    public boolean hasChildren() {
        return this.hasChildren;
    }

    @Override
    protected Axiom getAxiom() {
        return this.mAxiom;
    }

    @Override
    public Set<IRI> getNamedGraphs() {
        return this.mNamedGraphs;
    }

    @Override
    public Proof getAlternate() {
        return this.mAlternate;
    }

    @Override
    public boolean hasAlternate() {
        return this.mAlternate != null;
    }
}

