/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.clarkparsia.pellet.api.io.OntologyWriter;
import com.clarkparsia.pellet.api.io.OntologyWriterFactory;
import com.clarkparsia.pellet.api.io.OntologyWriterOptions;
import com.clarkparsia.pellet.api.io.impl.TerpWriterFactory;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.complexible.common.base.Options;
import com.complexible.common.rdf.model.RuleVocab;
import com.complexible.common.util.PrefixMapping;
import com.complexible.stardog.reasoning.ReasoningUtils;
import com.google.common.collect.Iterables;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import org.apache.commons.lang3.SystemUtils;

public final class ExpressionWriter {
    private static final OntologyWriterFactory FACTORY = new TerpWriterFactory();
    private final PrefixMapping aPrefixMapping = new PrefixMapping(false);
    private OntologyWriter writer;
    private StringWriter sw;

    public static String toString(Statement ... theStmts) {
        return ExpressionWriter.toString(Arrays.asList(theStmts));
    }

    public static String toString(Iterable<Namespace> theNamespaces, Statement ... theStmts) {
        return ExpressionWriter.toString(theNamespaces, Arrays.asList(theStmts));
    }

    public static String toString(Iterable<Statement> theStmts) {
        return ExpressionWriter.toString((Iterable<Namespace>)Namespaces.DEFAULT, theStmts);
    }

    public static String toString(Iterable<Namespace> theNamespaces, Iterable<Statement> theStmts) {
        return new ExpressionWriter(theNamespaces).write(theStmts).toString();
    }

    public ExpressionWriter() {
        this((Iterable<Namespace>)Namespaces.DEFAULT);
    }

    public ExpressionWriter(Iterable<Namespace> theNamespaces) {
        this(theNamespaces, Options.empty());
    }

    public ExpressionWriter(Iterable<Namespace> theNamespaces, Options theOptions) {
        for (Namespace aNamespace : theNamespaces) {
            this.aPrefixMapping.setMapping(aNamespace.prefix(), aNamespace.iri());
        }
        this.writer = (OntologyWriter)FACTORY.create(theOptions.copy().set(OntologyWriterOptions.PREFIX_MAPPING, (Object)this.aPrefixMapping).set(OntologyWriterOptions.AUTO_GENERATE_PREFIXES, (Object)false));
        this.sw = new StringWriter();
    }

    public String formatURI(String theURI) {
        return this.aPrefixMapping.qname(theURI, false);
    }

    public ExpressionWriter write(Iterable<Statement> theStmts) {
        this.writeAxioms(ReasoningUtils.convertToAxioms(theStmts));
        for (Statement aStmt : theStmts) {
            if (!aStmt.predicate().equals((Object)RuleVocab.content)) continue;
            this.sw.append(Value.lex((Value)aStmt.object()));
            this.sw.append(SystemUtils.LINE_SEPARATOR);
        }
        return this;
    }

    public ExpressionWriter writeAll(Iterable<? extends Iterable<Statement>> theStmts) {
        return this.writeAxioms(ReasoningUtils.convertToAxioms(Iterables.concat(theStmts)));
    }

    protected ExpressionWriter writeAxioms(Iterable<Axiom> theAxioms) {
        try {
            this.writer.write(theAxioms, this.sw);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ExpressionWriter reset() {
        this.sw.getBuffer().setLength(0);
        return this;
    }

    public String toString() {
        return this.sw.toString();
    }
}

