/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.complexible.common.base.Options;
import com.complexible.stardog.StardogException;
import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ReasonerExplainerOptions;
import com.complexible.stardog.reasoning.StardogExplainer;
import com.google.common.collect.Iterables;
import com.stardog.stark.IRI;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class AbstractStardogExplainer<E>
implements StardogExplainer {
    private final Options mOptions = Options.create();
    private final E mExpression;

    protected AbstractStardogExplainer(E theExpression) {
        this.mExpression = theExpression;
    }

    @Override
    public StardogExplainer countLimit(int theLimit) {
        this.mOptions.set(ReasonerExplainerOptions.COUNT_LIMIT, (Object)theLimit);
        return this;
    }

    @Override
    public StardogExplainer timeLimit(long theLimit, TimeUnit theUnit) {
        this.mOptions.set(ReasonerExplainerOptions.TIME_LIMIT_MS, (Object)theUnit.toMillis(theLimit));
        return this;
    }

    @Override
    public StardogExplainer computeNamedGraphs() {
        this.mOptions.set(ReasonerExplainerOptions.COMPUTE_NAMED_GRAPHS, (Object)true);
        return this;
    }

    @Override
    public StardogExplainer mergeExplanations() {
        this.mOptions.set(ReasonerExplainerOptions.MERGE_EXPLANATIONS, (Object)true);
        return this;
    }

    @Override
    public StardogExplainer activeGraphs(Collection<IRI> theActiveGraphs) {
        this.mOptions.set(ReasonerExplainerOptions.ACTIVE_GRAPHS, theActiveGraphs);
        return this;
    }

    @Override
    public Iterable<Proof> proofs() throws StardogException {
        return this.proofs(this.mExpression, this.mOptions);
    }

    @Override
    public Proof proof() throws StardogException {
        this.countLimit(1);
        return (Proof)Iterables.getFirst(this.proofs(this.mExpression, this.mOptions), null);
    }

    protected abstract Iterable<Proof> proofs(E var1, Options var2) throws StardogException;
}

