/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.reasoning;

import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.complexible.stardog.reasoning.Proof;
import com.complexible.stardog.reasoning.ProofType;
import com.complexible.stardog.reasoning.ProofWriter;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

abstract class AbstractProof
implements Proof {
    private static final Predicate<Proof> ASSERTED_NODES = AbstractProof.filterNodes(ProofType.ASSERTED);
    private static final Function<Proof, Iterator<Statement>> STMT_FUNC = theNode -> {
        Set<IRI> aNamedGraphs = theNode.getNamedGraphs();
        if (aNamedGraphs.isEmpty()) {
            return theNode.getExpression().iterator();
        }
        ArrayList aIterators = Lists.newArrayList();
        for (IRI aNamedGraph : aNamedGraphs) {
            aIterators.add(Iterators.transform((Iterator)theNode.getExpression().iterator(), theStmt -> Values.statement((Resource)theStmt.subject(), (IRI)theStmt.predicate(), (Value)theStmt.object(), (Resource)aNamedGraph)));
        }
        return aIterators.size() == 1 ? (Iterator)aIterators.get(0) : Iterators.concat(aIterators.iterator());
    };
    private static final Function<Proof, Iterator<com.stardog.stark.Axiom>> EXPR_FUNC = theNode -> Iterators.singletonIterator((Object)theNode.getExpression());

    AbstractProof() {
    }

    protected abstract Axiom getAxiom();

    @Override
    public Iterable<com.stardog.stark.Axiom> getExpressions() {
        return this.collectResults(ASSERTED_NODES, EXPR_FUNC);
    }

    @Override
    public Iterable<Statement> getStatements() {
        return this.collectResults(ASSERTED_NODES, STMT_FUNC);
    }

    @Override
    public Iterable<com.stardog.stark.Axiom> getExpressions(ProofType theStatus) {
        return this.collectResults(AbstractProof.filterNodes(theStatus), EXPR_FUNC);
    }

    @Override
    public Iterable<Statement> getStatements(ProofType theStatus) {
        return this.collectResults(AbstractProof.filterNodes(theStatus), STMT_FUNC);
    }

    private <T> List<T> collectResults(Predicate<Proof> theFilter, Function<Proof, Iterator<T>> theFunction) {
        ArrayList aResult = Lists.newArrayList();
        ArrayDeque aQueue = Queues.newArrayDeque();
        aQueue.add(this);
        while (!aQueue.isEmpty()) {
            Proof aNode = (Proof)aQueue.remove();
            if (theFilter.test(aNode)) {
                Iterators.addAll((Collection)aResult, theFunction.apply(aNode));
            }
            Iterables.addAll((Collection)aQueue, aNode.getChildren());
        }
        return aResult;
    }

    private static Predicate<Proof> filterNodes(ProofType theStatus) {
        return theNode -> theNode.getType() == theStatus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getAxiom() == null ? 0 : this.getAxiom().hashCode());
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractProof) {
            AbstractProof other = (AbstractProof)obj;
            return Objects.equal((Object)this.getAxiom(), (Object)other.getAxiom()) && this.getType() == other.getType() && this.getChildren().equals(other.getChildren());
        }
        return false;
    }

    @Override
    public String toString(Iterable<Namespace> theNamespaces) {
        return ProofWriter.toString(theNamespaces, this);
    }

    public String toString() {
        return ProofWriter.toString(this);
    }
}

