/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.terms;

import com.clarkparsia.pellet.api.term.Subsumption;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.TermSet;
import com.clarkparsia.pellet.api.term.axiom.DatatypeDefinition;
import com.clarkparsia.pellet.api.term.axiom.EntityAnnotation;
import com.clarkparsia.pellet.api.term.axiom.EquivalentClasses;
import com.clarkparsia.pellet.api.term.axiom.SubAnnotationPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubClassOf;
import com.clarkparsia.pellet.api.term.axiom.SubDataPropertyOf;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyChain;
import com.clarkparsia.pellet.api.term.axiom.SubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.entity.AnnotationPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.ClassVariable;
import com.clarkparsia.pellet.api.term.entity.DataPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.DatatypeVariable;
import com.clarkparsia.pellet.api.term.entity.IndividualVariable;
import com.clarkparsia.pellet.api.term.entity.NamedAnnotationProperty;
import com.clarkparsia.pellet.api.term.entity.NamedClass;
import com.clarkparsia.pellet.api.term.entity.NamedDataProperty;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.entity.NamedIndividual;
import com.clarkparsia.pellet.api.term.entity.NamedObjectProperty;
import com.clarkparsia.pellet.api.term.entity.ObjectAnd;
import com.clarkparsia.pellet.api.term.entity.ObjectOr;
import com.clarkparsia.pellet.api.term.entity.ObjectPropertyVariable;
import com.clarkparsia.pellet.api.term.entity.RestrictedDatatype;
import com.clarkparsia.pellet.api.term.query.DirectSubClassOf;
import com.clarkparsia.pellet.api.term.query.DirectSubDataPropertyOf;
import com.clarkparsia.pellet.api.term.query.DirectSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.query.StrictSubClassOf;
import com.clarkparsia.pellet.api.term.query.StrictSubDataPropertyOf;
import com.clarkparsia.pellet.api.term.query.StrictSubObjectPropertyOf;
import com.clarkparsia.pellet.api.term.visitor.BaseTermVisitor;
import com.google.common.base.Predicate;

public class TermMatcher
extends BaseTermVisitor<Boolean>
implements Predicate<Term> {
    private Term pattern;

    public TermMatcher(Term pattern) {
        this.pattern = pattern;
    }

    public boolean apply(Term term) {
        return term.accept(this);
    }

    private boolean matches(Term term, Term newPattern) {
        Term oldPattern = this.pattern;
        this.pattern = newPattern;
        boolean result = term.accept(this);
        this.pattern = oldPattern;
        return result;
    }

    private <T extends Term> boolean matches(TermSet<T> term, Class<? extends TermSet<T>> type) {
        if (!type.isInstance(this.pattern)) {
            return false;
        }
        TermSet ptrn = (TermSet)((Object)this.pattern);
        for (Term t1 : ptrn) {
            boolean matched = false;
            for (Term t2 : term) {
                if (!this.matches(t2, t1)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    private <T extends Subsumption> boolean matches(T term, Class<T> type) {
        if (!type.isInstance(this.pattern)) {
            return false;
        }
        Subsumption patternTerm = (Subsumption)((Object)this.pattern);
        return this.matches(term.getSub(), patternTerm.getSub()) && this.matches(term.getSuper(), patternTerm.getSuper());
    }

    @Override
    protected Boolean defaultVisit(Term term) {
        return Boolean.FALSE;
    }

    @Override
    public Boolean visit(NamedAnnotationProperty p) {
        return this.pattern instanceof AnnotationPropertyVariable || this.pattern.equals(p);
    }

    @Override
    public Boolean visit(NamedClass c) {
        return this.pattern instanceof ClassVariable || this.pattern.equals(c);
    }

    @Override
    public Boolean visit(NamedDataProperty p) {
        return this.pattern instanceof DataPropertyVariable || this.pattern.equals(p);
    }

    @Override
    public Boolean visit(NamedDatatype d) {
        return this.pattern instanceof DatatypeVariable || this.pattern.equals(d);
    }

    @Override
    public Boolean visit(NamedIndividual ind) {
        return this.pattern instanceof IndividualVariable || this.pattern.equals(ind);
    }

    @Override
    public Boolean visit(NamedObjectProperty p) {
        return this.pattern instanceof ObjectPropertyVariable || this.pattern.equals(p);
    }

    @Override
    public Boolean visit(ObjectAnd c) {
        return this.pattern instanceof ClassVariable || this.matches((Subsumption)((Object)c), (Class)ObjectAnd.class);
    }

    @Override
    public Boolean visit(ObjectOr c) {
        return this.pattern instanceof ClassVariable || this.matches((Subsumption)((Object)c), (Class)ObjectOr.class);
    }

    @Override
    public Boolean visit(RestrictedDatatype d) {
        return this.pattern instanceof DatatypeVariable || this.pattern instanceof RestrictedDatatype && this.matches(d.getDatatype(), ((RestrictedDatatype)this.pattern).getDatatype());
    }

    @Override
    public Boolean visit(EquivalentClasses axiom) {
        return this.matches((Subsumption)((Object)axiom), (Class)EquivalentClasses.class);
    }

    @Override
    public Boolean visit(SubClassOf axiom) {
        return this.matches(axiom, SubClassOf.class);
    }

    @Override
    public Boolean visit(SubObjectPropertyOf axiom) {
        return this.matches(axiom, SubObjectPropertyOf.class);
    }

    @Override
    public Boolean visit(SubDataPropertyOf axiom) {
        return this.matches(axiom, SubDataPropertyOf.class);
    }

    @Override
    public Boolean visit(DirectSubClassOf query) {
        return this.matches(query, DirectSubClassOf.class);
    }

    @Override
    public Boolean visit(DirectSubDataPropertyOf query) {
        return this.matches(query, DirectSubDataPropertyOf.class);
    }

    @Override
    public Boolean visit(DirectSubObjectPropertyOf query) {
        return this.matches(query, DirectSubObjectPropertyOf.class);
    }

    @Override
    public Boolean visit(StrictSubClassOf query) {
        return this.matches(query, StrictSubClassOf.class);
    }

    @Override
    public Boolean visit(StrictSubDataPropertyOf query) {
        return this.matches(query, StrictSubDataPropertyOf.class);
    }

    @Override
    public Boolean visit(StrictSubObjectPropertyOf query) {
        return this.matches(query, StrictSubObjectPropertyOf.class);
    }

    @Override
    public Boolean visit(SubAnnotationPropertyOf axiom) {
        return this.matches(axiom, SubAnnotationPropertyOf.class);
    }

    @Override
    public Boolean visit(SubObjectPropertyChain axiom) {
        return this.matches(axiom, SubObjectPropertyChain.class);
    }

    @Override
    public Boolean visit(DatatypeDefinition axiom) {
        if (this.pattern instanceof DatatypeDefinition) {
            DatatypeDefinition ptrn = (DatatypeDefinition)this.pattern;
            return this.matches(axiom.getDatatype(), ptrn.getDatatype()) && this.matches(axiom.getDefinition(), ptrn.getDefinition());
        }
        return false;
    }

    @Override
    public Boolean visit(EntityAnnotation annotation) {
        if (this.pattern instanceof EntityAnnotation) {
            EntityAnnotation ptrn = (EntityAnnotation)this.pattern;
            return !(!ptrn.getSubject().isVariable() && !ptrn.getSubject().equals(annotation.getSubject()) || !ptrn.getProperty().isVariable() && !ptrn.getProperty().equals(annotation.getProperty()) || !ptrn.getObject().isVariable() && !ptrn.getObject().equals(annotation.getObject()));
        }
        return false;
    }
}

