/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.progress;

import com.clarkparsia.pellet.util.progress.AbstractProgressMonitor;
import com.clarkparsia.pellet.util.progress.ProgressMonitor;
import com.complexible.common.timer.DurationFormat;
import java.io.PrintStream;

public class ConsoleProgressMonitor
extends AbstractProgressMonitor
implements ProgressMonitor {
    private PrintStream out;

    public ConsoleProgressMonitor() {
        this(System.err, 0);
    }

    public ConsoleProgressMonitor(PrintStream out) {
        this(out, 0);
    }

    public ConsoleProgressMonitor(int length) {
        this(System.err, length);
    }

    public ConsoleProgressMonitor(PrintStream out, int length) {
        this.out = out;
        this.setProgressLength(length);
        this.setProgressTitle("");
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
    }

    @Override
    public void taskStarted() {
        super.taskStarted();
        this.out.println(this.progressTitle + " " + this.progressLength + " elements");
    }

    @Override
    protected void updateProgress() {
        int pc = (int)(100.0 * (double)this.progress / (double)this.progressLength);
        if (pc == this.progressPercent) {
            return;
        }
        this.progressPercent = pc;
        this.out.print('\r');
        this.out.print(this.progressTitle);
        this.out.print(": ");
        this.out.print(this.progressPercent);
        this.out.print("% complete in ");
        this.out.print(DurationFormat.SHORT.format(this.getElapsedTime()));
    }

    @Override
    public void taskFinished() {
        super.taskFinished();
        this.out.println();
        this.out.print(this.progressTitle);
        this.out.print(" finished in ");
        this.out.println(DurationFormat.SHORT.format(this.getElapsedTime()));
    }
}

