/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.intset;

import com.clarkparsia.pellet.util.intset.IntIterator;
import com.clarkparsia.pellet.util.intset.IntSet;
import java.util.BitSet;
import java.util.NoSuchElementException;

public class BitIntSet
implements IntSet {
    private BitSet bits;

    public BitIntSet() {
        this.bits = new BitSet();
    }

    public BitIntSet(BitIntSet other) {
        this.bits = (BitSet)other.bits.clone();
    }

    @Override
    public void add(int value) {
        if (value < 0) {
            throw new UnsupportedOperationException("Negatibe integers cannot be added to this set");
        }
        this.bits.set(value);
    }

    @Override
    public void addAll(IntSet values) {
        if (values instanceof BitIntSet) {
            this.bits.or(((BitIntSet)values).bits);
        } else {
            IntIterator i = values.iterator();
            while (i.hasNext()) {
                this.add(i.next());
            }
        }
    }

    @Override
    public boolean contains(int value) {
        return this.bits.get(value);
    }

    @Override
    public IntSet copy() {
        return new BitIntSet(this);
    }

    @Override
    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int next;
            {
                this.next = BitIntSet.this.bits.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.next != -1;
            }

            @Override
            public int next() {
                int curr = this.next;
                if (curr == -1) {
                    throw new NoSuchElementException();
                }
                this.next = BitIntSet.this.bits.nextSetBit(0);
                return curr;
            }
        };
    }

    @Override
    public int max() {
        return this.bits.length() - 1;
    }

    @Override
    public int min() {
        return this.bits.nextSetBit(0);
    }

    @Override
    public void remove(int value) {
        if (value >= 0) {
            this.bits.clear(value);
        }
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }

    @Override
    public IntSet union(IntSet values) {
        IntSet newSet = this.copy();
        newSet.addAll(values);
        return newSet;
    }
}

