/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.intset;

import com.clarkparsia.pellet.util.intset.IntIterator;
import com.clarkparsia.pellet.util.intset.IntSet;
import java.util.NoSuchElementException;

public abstract class AbstractIntSet
implements IntSet {
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;

    @Override
    public void addAll(IntSet values) {
        IntIterator i = values.iterator();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    protected void added(int low, int high) {
        if (low < this.min) {
            this.min = low;
        }
        if (high > this.max) {
            this.max = high;
        }
    }

    @Override
    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.max;
    }

    @Override
    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.min;
    }

    protected void removed(int low, int high) {
        if (this.isEmpty() || low == this.min || high == this.max) {
            this.min = Integer.MAX_VALUE;
            this.max = Integer.MIN_VALUE;
            IntIterator i = this.iterator();
            while (i.hasNext()) {
                int value = i.next();
                if (value < this.min) {
                    this.min = value;
                }
                if (value <= this.max) continue;
                this.max = value;
            }
        }
    }

    @Override
    public IntSet union(IntSet values) {
        IntSet newSet = this.copy();
        newSet.addAll(values);
        return newSet;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        IntIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(String.valueOf(i.next()));
        }
        s.append(']');
        return s.toString();
    }
}

