/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.collections;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultimapUtils {
    public static <K, V> boolean add(Map<K, Set<V>> map, K key, V value) {
        HashSet values = map.get(key);
        if (values == null) {
            values = Sets.newHashSet();
            map.put(key, values);
        }
        return values.add(value);
    }

    public static <K, V> boolean addAll(Map<K, Set<V>> map, K key, Collection<? extends V> collection) {
        HashSet values = map.get(key);
        if (values == null) {
            values = Sets.newHashSet();
            map.put(key, values);
        }
        return values.addAll(collection);
    }

    public static <K, V> boolean contains(Map<K, Set<V>> map, K key, V value) {
        return MultimapUtils.get(map, key).contains(value);
    }

    public static <K, V> boolean containsAll(Map<K, Set<V>> map, K key, Collection<? extends V> collection) {
        return MultimapUtils.get(map, key).containsAll(collection);
    }

    public static <K, V> Iterable<V> flattenedValues(Map<K, Set<V>> map) {
        return Iterables.concat(map.values());
    }

    public static <K, V> Set<V> get(Map<K, Set<V>> map, K key) {
        ImmutableSet values = map.get(key);
        return values != null ? values : ImmutableSet.of();
    }

    public static <K, V> boolean removeAll(Map<K, Set<V>> map, K key, Collection<? extends V> collection) {
        boolean removed = false;
        Set<V> values = map.get(key);
        if (values != null) {
            removed = values.removeAll(collection);
            if (values.isEmpty()) {
                map.remove(key);
            }
        }
        return removed;
    }

    public static <K, V> boolean remove(Map<K, Set<V>> map, K key, V value) {
        boolean removed = false;
        Set<V> values = map.get(key);
        if (values != null) {
            removed = values.remove(value);
            if (values.isEmpty()) {
                map.remove(key);
            }
        }
        return removed;
    }
}

