/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.util.collections;

import com.complexible.common.base.Bool;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CandidateSet<T> {
    private Set<T> knowns;
    private Set<T> unknowns;

    public CandidateSet() {
        this.knowns = new HashSet<T>();
        this.unknowns = new HashSet<T>();
    }

    public CandidateSet(Collection<T> knowns) {
        this.knowns = new HashSet<T>(knowns);
        this.unknowns = new HashSet<T>();
    }

    public CandidateSet(Collection<T> knowns, Collection<T> unknowns) {
        this.knowns = new HashSet<T>(knowns);
        this.unknowns = new HashSet<T>(unknowns);
    }

    public Set<T> getKnowns() {
        return this.knowns;
    }

    public Set<T> getUnknowns() {
        return this.unknowns;
    }

    public void add(T obj, Bool isKnown) {
        if (isKnown.isTrue()) {
            this.knowns.add(obj);
        } else if (!isKnown.isKnown()) {
            this.unknowns.add(obj);
        }
    }

    public void update(T obj, Bool isCandidate) {
        if (!isCandidate.isTrue()) {
            if (isCandidate.isFalse()) {
                this.remove(obj);
            } else if (this.knowns.contains(obj)) {
                this.knowns.remove(obj);
                this.unknowns.add(obj);
            }
        }
    }

    public boolean remove(Object obj) {
        return this.knowns.remove(obj) || this.unknowns.remove(obj);
    }

    public boolean contains(Object obj) {
        return this.knowns.contains(obj) || this.unknowns.contains(obj);
    }

    public int size() {
        return this.knowns.size() + this.unknowns.size();
    }

    public Iterator<T> iterator() {
        return Iterators.concat(this.knowns.iterator(), this.unknowns.iterator());
    }

    public String toString() {
        return "Knowns: " + this.knowns.size() + " Unknowns: " + this.unknowns.size();
    }
}

