/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.stark;

import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.rdf.AbstractRDFOutput;
import com.clarkparsia.pellet.rdf.RDFOutput;
import com.clarkparsia.pellet.rdf.RDFOutputProvider;
import com.clarkparsia.pellet.stark.StarkRDFFactory;
import com.google.common.collect.ImmutableMap;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFWriters;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.io.output.WriterOutputStream;

public class StarkRDFHandlerOutput
extends AbstractRDFOutput<RDFHandler, Statement, Value, Resource, IRI> {
    public static final RDFOutputProvider<RDFHandler, Value, Resource, IRI> PROVIDER = new RDFOutputProvider<RDFHandler, Value, Resource, IRI>(){

        @Override
        public RDFOutput<Value, Resource, IRI> getOutput(OutputStream out, OntologySyntax syntax) {
            return this.getOutput((RDFHandler)RDFWriters.to((OutputStream)out, (RDFFormat)StarkRDFHandlerOutput.getFormat(syntax)).get());
        }

        @Override
        public RDFOutput<Value, Resource, IRI> getOutput(Writer writer, OntologySyntax syntax) {
            return this.getOutput((RDFHandler)RDFWriters.to((OutputStream)new WriterOutputStream(writer), (RDFFormat)StarkRDFHandlerOutput.getFormat(syntax)).get());
        }

        @Override
        public RDFOutput<Value, Resource, IRI> getOutput(RDFHandler graph) {
            return new StarkRDFHandlerOutput(graph);
        }
    };
    public static final Map<OntologySyntax, RDFFormat> SYNTAX_MAPPING = ImmutableMap.of((Object)OntologySyntax.RDF_XML, (Object)RDFFormats.RDFXML, (Object)OntologySyntax.TURTLE, (Object)RDFFormats.TURTLE);

    protected static RDFFormat getFormat(OntologySyntax syntax) {
        RDFFormat format = SYNTAX_MAPPING.get(syntax);
        if (format == null) {
            throw new UnsupportedOperationException("Unsupported syntax: " + String.valueOf(syntax));
        }
        return format;
    }

    public StarkRDFHandlerOutput(RDFHandler graph) {
        this(graph, StarkRDFFactory.INSTANCE);
    }

    public StarkRDFHandlerOutput(RDFHandler graph, StarkRDFFactory factory) {
        super(graph, factory);
    }

    @Override
    public void start() {
        try {
            ((RDFHandler)this.graph).start();
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        try {
            ((RDFHandler)this.graph).end();
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void add(Resource subj, IRI pred, Value obj) {
        try {
            ((RDFHandler)this.graph).handle((Statement)this.factory.createTriple(subj, pred, obj));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }
}

