/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.stark;

import com.clarkparsia.pellet.rdf.AbstractRDFFactory;
import com.stardog.stark.BNode;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;

public class StarkRDFFactory
extends AbstractRDFFactory<Statement, Value, Resource, IRI> {
    public static final StarkRDFFactory INSTANCE = new StarkRDFFactory();

    private StarkRDFFactory() {
    }

    @Override
    public Value createPlainLiteral(String lexicalValue, String language) {
        return Values.literal((String)lexicalValue, (String)language);
    }

    @Override
    public Value createPlainLiteral(String lexicalValue) {
        return Values.literal((String)lexicalValue);
    }

    @Override
    public Value createTypedLiteral(String lexicalValue, String datatypeURI) {
        return Values.literal((String)lexicalValue, (IRI)Values.iri((String)datatypeURI));
    }

    @Override
    public Resource createResource() {
        return Values.bnode();
    }

    @Override
    public Resource createVariable(String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IRI createPredicate(String uri) {
        return Values.iri((String)uri);
    }

    @Override
    public Resource createResource(String uri) {
        return Values.iri((String)uri);
    }

    @Override
    public Statement createTriple(Resource s, IRI p, Value o) {
        return Values.statement((Resource)s, (IRI)p, (Value)o);
    }

    @Override
    public Value getTripleObject(Statement triple) {
        return triple.object();
    }

    @Override
    public IRI getTriplePredicate(Statement triple) {
        return triple.predicate();
    }

    @Override
    public Resource getTripleSubject(Statement triple) {
        return triple.subject();
    }

    @Override
    public String getLabel(Value node) {
        return Value.lex((Value)node);
    }

    @Override
    public String getLiteralDatatype(Value node) {
        return ((Literal)node).datatypeIRI().toString();
    }

    @Override
    public String getLiteralLanguage(Value node) {
        return ((Literal)node).lang().orElse(null);
    }

    @Override
    public boolean isBlank(Value node) {
        return node instanceof BNode;
    }

    @Override
    public boolean isLiteral(Value node) {
        return node instanceof Literal;
    }

    @Override
    public boolean isURI(Value node) {
        return node instanceof IRI;
    }

    @Override
    public boolean isVariable(Value node) {
        return false;
    }
}

