/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.api.factory.AbstractFactory;
import com.clarkparsia.pellet.api.io.ExternalOntologyWriter;
import com.clarkparsia.pellet.api.io.OntologySyntax;
import com.clarkparsia.pellet.api.io.OntologyWriter;
import com.clarkparsia.pellet.api.io.OntologyWriterFactory;
import com.clarkparsia.pellet.api.io.impl.AbstractOntologyWriter;
import com.clarkparsia.pellet.api.term.axiom.Axiom;
import com.clarkparsia.pellet.rdf.RDFAxiomWriter;
import com.clarkparsia.pellet.rdf.RDFAxiomWriters;
import com.clarkparsia.pellet.rdf.RDFOutput;
import com.clarkparsia.pellet.rdf.RDFOutputProvider;
import com.complexible.common.base.Options;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class RDFOntologyWriterFactory<Graph, Node, Resource extends Node, Predicate extends Resource>
extends AbstractFactory<OntologyWriter>
implements OntologyWriterFactory {
    private final OntologySyntax syntax;
    private final RDFOutputProvider<Graph, Node, Resource, Predicate> factory;

    public static <G, N, R extends N, P extends R> OntologyWriterFactory create(RDFOutputProvider<G, N, R, P> factory, OntologySyntax syntax) {
        return new RDFOntologyWriterFactory<G, N, R, P>(factory, syntax);
    }

    public static <G, N, R extends N, P extends R> ExternalOntologyWriter<G> createExternalWriter(RDFOutputProvider<G, N, R, P> factory, OntologySyntax syntax, Options options) {
        return new RDFOntologyWriterFactory<G, N, R, P>(factory, syntax).create(options);
    }

    public RDFOntologyWriterFactory(RDFOutputProvider<Graph, Node, Resource, Predicate> provider, OntologySyntax syntax) {
        this.factory = provider;
        this.syntax = syntax;
    }

    @Override
    public ExternalOntologyWriter<Graph> create(Options options) {
        return new RDFExternalOntologyWriter(options, this.syntax);
    }

    @Override
    public OntologySyntax getSyntax() {
        return this.syntax;
    }

    private class RDFExternalOntologyWriter
    extends AbstractOntologyWriter
    implements ExternalOntologyWriter<Graph> {
        public RDFExternalOntologyWriter(Options options, OntologySyntax syntax) {
            super(options, syntax);
        }

        @Override
        public void write(Iterable<? extends Axiom> kb, RDFOutput<Node, Resource, Predicate> output) {
            RDFAxiomWriter axiomWriter = RDFAxiomWriters.create(this.options);
            output.start();
            axiomWriter.write(kb, output);
            output.end();
        }

        @Override
        public void write(Iterable<? extends Axiom> kb, Writer writer) throws IOException {
            this.write(kb, (Graph)RDFOntologyWriterFactory.this.factory.getOutput(writer, this.syntax));
        }

        @Override
        public void write(Iterable<? extends Axiom> kb, OutputStream in) throws IOException {
            this.write(kb, (Graph)RDFOntologyWriterFactory.this.factory.getOutput(in, this.syntax));
        }

        @Override
        public void write(Iterable<? extends Axiom> kb, Graph graph) {
            this.write(kb, (Graph)RDFOntologyWriterFactory.this.factory.getOutput(graph));
        }
    }
}

