/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rdf;

import com.clarkparsia.pellet.api.kb.KnowledgeBase;
import com.clarkparsia.pellet.api.term.entity.ClassExpression;
import com.clarkparsia.pellet.rdf.DefaultRDFAxiomReader;
import com.clarkparsia.pellet.rdf.RDFParseException;
import com.clarkparsia.pellet.rdf.RDFTerm;
import com.clarkparsia.pellet.rdf.RDFTerms;
import com.complexible.common.base.Bool;
import com.complexible.common.base.Options;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CachingRDFAxiomReader<Graph, Triple, Node, Resource extends Node, Predicate extends Resource, ClosableIterator extends Iterator<Triple>>
extends DefaultRDFAxiomReader<Graph, Triple, Node, Resource, Predicate, ClosableIterator> {
    private Map<Node, Node> firsts;
    private Map<Node, Node> rests;
    private Map<Node, Triple> expressions;
    private Map<Node, RestrictionInfo> restrictions;

    public CachingRDFAxiomReader(Options options, KnowledgeBase kb) {
        super(options, kb);
    }

    @Override
    public void reset() {
        super.reset();
        this.restrictions = Maps.newHashMap();
        this.expressions = Maps.newHashMap();
        LOGGER.debug("processLists");
        this.processLists();
        LOGGER.debug("processRestrictions");
        this.processRestrictions();
        LOGGER.debug("processExpressions");
        this.processExpressions();
    }

    private void processLists() {
        this.firsts = new HashMap<Node, Node>();
        this.cacheObjects(RDFTerm.RDF_first, this.firsts);
        this.rests = new HashMap<Node, Node>();
        this.cacheObjects(RDFTerm.RDF_rest, this.rests);
    }

    private void handleParseException(String msg) {
        this.handleException(new RDFParseException(msg));
    }

    private void cacheObjects(RDFTerm pred, Map<Node, Node> values) {
        Object i = this.graph.find(null, pred, null);
        while (i.hasNext()) {
            this.monitor.incrementProgress();
            Object t = i.next();
            Node prevValue = values.put(this.factory.getTripleSubject(t), this.factory.getTripleObject(t));
            if (prevValue == null) continue;
            this.handleParseException("Multiple " + String.valueOf((Object)pred) + " values for " + String.valueOf(this.factory.getTripleSubject(t)) + " [" + String.valueOf(this.factory.getTripleObject(t)) + ", " + String.valueOf(prevValue) + "]");
        }
        this.graph.close(i);
    }

    private void cachePredicateObjects(Iterable<RDFTerm> pred, Map<Node, Triple> values) {
        this.cachePredicateObjects(pred, values, true);
    }

    private void cachePredicateObjects(Iterable<RDFTerm> preds, Map<Node, Triple> values, boolean onlyBnodes) {
        for (RDFTerm pred : preds) {
            Object i = this.graph.find(null, pred, null);
            while (i.hasNext()) {
                Triple prevValue;
                this.monitor.incrementProgress();
                Object t = i.next();
                if (onlyBnodes && !this.factory.isBlank(this.factory.getTripleSubject(t)) || (prevValue = values.put(this.factory.getTripleSubject(t), t)) == null) continue;
                this.handleParseException("Multiple owl:" + String.valueOf(this.factory.getTriplePredicate(t)) + " values for " + String.valueOf(this.factory.getTripleSubject(t)) + " [" + String.valueOf(this.factory.getTripleObject(t)) + ", " + String.valueOf(this.factory.getTripleObject(prevValue)) + "]");
            }
            this.graph.close(i);
        }
    }

    private void initializeRestrictions() {
        Object i = this.graph.find(null, RDFTerm.OWL_onProperty, null);
        while (i.hasNext()) {
            this.monitor.incrementProgress();
            Object t = i.next();
            RestrictionInfo info = new RestrictionInfo(this, this.factory.getTripleObject(t));
            RestrictionInfo prevValue = this.restrictions.put(this.factory.getTripleSubject(t), info);
            if (prevValue == null) continue;
            this.handleParseException("Multiple owl:onProperty values for " + String.valueOf(this.factory.getTripleSubject(t)) + " [" + String.valueOf(this.factory.getTripleObject(t)) + ", " + String.valueOf(prevValue.getPredicate()) + "]");
        }
        this.graph.close(i);
    }

    private void processRestrictionTypes() {
        for (RDFTerm pred : RDFTerms.RESTRICTIONS) {
            Object i = this.graph.find(null, pred, null);
            while (i.hasNext()) {
                this.monitor.incrementProgress();
                Object t = i.next();
                Object restrictionType = this.factory.getTriplePredicate(t);
                RestrictionInfo info = this.restrictions.get(this.factory.getTripleSubject(t));
                if (info == null) {
                    this.handleParseException("No owl:onProperty for owl:" + String.valueOf(restrictionType) + " restriction " + String.valueOf(this.factory.getTripleSubject(t)));
                    continue;
                }
                if (info.getType() != null) {
                    this.handleParseException("Multiple restrictions for same bnode " + String.valueOf(this.factory.getTripleSubject(t)) + " [" + String.valueOf(restrictionType) + ", " + String.valueOf((Object)info.getType()) + "]");
                    continue;
                }
                info.setType(this.factory.getTerm(restrictionType));
                info.setFiller(this.factory.getTripleObject(t));
            }
            this.graph.close(i);
        }
    }

    private void processRestrictionDetails(RDFTerm pred, Collection<RDFTerm> allowedTypes, boolean isObjectRestriction) {
        Object i = this.graph.find(null, pred, null);
        while (i.hasNext()) {
            this.monitor.incrementProgress();
            Object t = i.next();
            try {
                this.processRestrictionInfo(t, pred, allowedTypes, isObjectRestriction);
            }
            catch (RuntimeException e) {
                this.handleException(e);
            }
        }
        this.graph.close(i);
    }

    private void processRestrictionInfo(Triple t, RDFTerm pred, Collection<RDFTerm> allowedTypes, boolean isObjectRestriction) {
        RestrictionInfo info = this.restrictions.get(this.factory.getTripleSubject(t));
        if (info == null) {
            this.handleParseException("No owl:onProperty for owl:" + String.valueOf((Object)pred) + " restriction " + String.valueOf(this.factory.getTripleSubject(t)));
            return;
        }
        if (!allowedTypes.contains((Object)info.getType())) {
            this.handleParseException(String.format("Unexpected owl:%s value %s for %s restricion", new Object[]{pred, this.factory.getTripleObject(t), info.getType()}));
            return;
        }
        info.setDetail(this.factory.getTripleObject(t));
        info.setObjectRestriction(isObjectRestriction);
    }

    private void processExpressions() {
        this.cachePredicateObjects((Iterable<RDFTerm>)RDFTerms.EXPRESSIONS, this.expressions);
    }

    private void processRestrictions() {
        this.initializeRestrictions();
        this.processRestrictionTypes();
        this.processRestrictionDetails(RDFTerm.OWL2_onClass, (Collection<RDFTerm>)RDFTerms.QUALIFIED_RESTRICTIONS, true);
        this.processRestrictionDetails(RDFTerm.OWL2_onDataRange, (Collection<RDFTerm>)RDFTerms.QUALIFIED_RESTRICTIONS, false);
    }

    @Override
    protected Triple getExpression(Resource node) {
        return this.expressions.get(node);
    }

    @Override
    protected Node getFirst(Resource list) {
        return this.firsts.get(list);
    }

    @Override
    protected Node getRest(Resource list) {
        return this.rests.get(list);
    }

    @Override
    protected boolean isRestriction(Resource node) {
        return this.restrictions.containsKey(node);
    }

    @Override
    protected ClassExpression createRestriction(Resource node) {
        RestrictionInfo info = this.restrictions.get(node);
        return this.createRestriction(info.getType(), info.getPredicate(), info.getFiller(), info.getDetail(), info.isObjectRestriction());
    }

    private class RestrictionInfo {
        private RDFTerm type;
        private final Node predicate;
        private Node filler;
        private Node detail;
        private Bool isObjectRestriction = Bool.UNKNOWN;

        public RestrictionInfo(CachingRDFAxiomReader cachingRDFAxiomReader, Node predicate) {
            this.predicate = predicate;
        }

        public RDFTerm getType() {
            return this.type;
        }

        public void setType(RDFTerm type) {
            this.type = type;
        }

        public Node getPredicate() {
            return this.predicate;
        }

        public Node getFiller() {
            return this.filler;
        }

        public void setFiller(Node filler) {
            this.filler = filler;
        }

        public Node getDetail() {
            return this.detail;
        }

        public void setDetail(Node detail) {
            this.detail = detail;
        }

        public Bool isObjectRestriction() {
            return this.isObjectRestriction;
        }

        public void setObjectRestriction(boolean isObjectRestriction) {
            this.isObjectRestriction = Bool.valueOf((boolean)isObjectRestriction);
        }
    }
}

