/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.hierarchy.impl;

import com.clarkparsia.pellet.hierarchy.Hierarchy;
import com.clarkparsia.pellet.hierarchy.HierarchyNode;
import com.clarkparsia.pellet.hierarchy.HierarchyWriter;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Set;

public class IndentedHierarchyWriter<T>
implements HierarchyWriter<T> {
    @Override
    public void write(Hierarchy<T> classHierarchy, OutputStream out) {
        this.write(classHierarchy.getTop(), out);
    }

    @Override
    public void write(HierarchyNode<T> node, OutputStream out) {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        this.write(node, Sets.newHashSet(), ps, "");
    }

    private void write(HierarchyNode<T> node, Set<HierarchyNode<T>> visited, PrintStream out, String indent) {
        if (node.isBottom()) {
            return;
        }
        out.print((String)indent);
        out.print(this.format(node));
        if (!visited.add(node)) {
            out.println(" *Cycle*");
            return;
        }
        out.println();
        indent = (String)indent + "  ";
        for (HierarchyNode<T> sub : node.getSubs()) {
            this.write(sub, visited, out, (String)indent);
        }
        visited.remove(node);
    }

    protected String format(HierarchyNode<T> node) {
        return node.toString();
    }
}

