/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.hierarchy.impl;

import com.clarkparsia.pellet.hierarchy.Direction;
import com.clarkparsia.pellet.hierarchy.Hierarchy;
import com.clarkparsia.pellet.hierarchy.HierarchyIterator;
import com.clarkparsia.pellet.hierarchy.HierarchyNode;
import com.clarkparsia.pellet.hierarchy.HierarchyUtils;
import com.clarkparsia.pellet.hierarchy.impl.HierarchyImpl;
import com.complexible.common.base.DataKey;
import com.complexible.common.base.DataMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class HierarchyNodeImpl<T>
implements HierarchyNode<T> {
    private T element;
    private Set<T> elements;
    private HierarchyImpl<T> hierarchy;
    private Set<HierarchyNode<T>> subs;
    private Set<HierarchyNode<T>> supers;
    private DataMap dataMap;

    private HierarchyNodeImpl(HierarchyImpl<T> hierarchy, T element, Set<HierarchyNode<T>> subs, Set<HierarchyNode<T>> supers) {
        this.element = element;
        this.elements = element == null ? ImmutableSet.of() : ImmutableSet.of(element);
        this.hierarchy = hierarchy;
        this.subs = subs;
        this.supers = supers;
        this.dataMap = DataMap.of();
    }

    static <T> HierarchyNode<T> createTop(HierarchyImpl<T> hierarchy, T element) {
        return new HierarchyNodeImpl<T>(hierarchy, element, Sets.newIdentityHashSet(), ImmutableSet.of());
    }

    static <T> HierarchyNode<T> createBottom(HierarchyImpl<T> hierarchy, T element) {
        return new HierarchyNodeImpl<T>(hierarchy, element, ImmutableSet.of(), Sets.newIdentityHashSet());
    }

    static <T> HierarchyNode<T> createNode(HierarchyImpl<T> hierarchy, T element) {
        return new HierarchyNodeImpl<T>(hierarchy, element, Sets.newIdentityHashSet(), Sets.newIdentityHashSet());
    }

    static <T> HierarchyNode<T> createImmutableNode(HierarchyImpl<T> hierarchy, Iterable<HierarchyNode<T>> subs, Iterable<HierarchyNode<T>> supers) {
        return new HierarchyNodeImpl<Object>((HierarchyImpl<Object>)hierarchy, null, (Set<HierarchyNode<Object>>)ImmutableSet.copyOf(subs), (Set<HierarchyNode<Object>>)ImmutableSet.copyOf(supers));
    }

    @Override
    public boolean addElement(T element) {
        if (this.elements.contains(element)) {
            return false;
        }
        Preconditions.checkArgument((!this.hierarchy.contains(element) ? 1 : 0) != 0, (String)"Element already exists: %s", element);
        if (this.elements.size() <= 1) {
            this.elements = Sets.newHashSet(this.elements);
        }
        this.elements.add(element);
        this.hierarchy.nodes.put(element, this);
        return true;
    }

    @Override
    public boolean removeElement(T element) {
        if (!this.elements.contains(element)) {
            return false;
        }
        if (this.elements.size() == 1) {
            this.elements = ImmutableSet.of();
        } else {
            this.elements.remove(element);
        }
        this.hierarchy.nodes.remove(element);
        return true;
    }

    @Override
    public HierarchyIterator<T> nodeIterator() {
        return HierarchyIterator.create(this);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean addSub(HierarchyNode<T> sub) {
        if (this.subs.add(sub)) {
            ((HierarchyNodeImpl)sub).supers.add(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeSub(HierarchyNode<T> sub) {
        if (this.subs.remove(sub)) {
            ((HierarchyNodeImpl)sub).supers.remove(this);
            return true;
        }
        return false;
    }

    @Override
    public <V> V getData(DataKey<V> key) {
        return (V)this.dataMap.get(key);
    }

    @Override
    public DataMap getDataMap() {
        return this.dataMap;
    }

    @Override
    public T getElement() {
        return this.element;
    }

    @Override
    public Set<T> getElements() {
        return this.elements;
    }

    @Override
    public Hierarchy<T> getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public Collection<HierarchyNode<T>> getSubs() {
        return this.subs;
    }

    @Override
    public Collection<HierarchyNode<T>> getSupers() {
        return this.supers;
    }

    @Override
    public boolean isEmpty() {
        return this.element == null;
    }

    @Override
    public boolean isBottom() {
        return this.hierarchy.getBottom() == this;
    }

    @Override
    public boolean isTop() {
        return this.hierarchy.getTop() == this;
    }

    @Override
    public boolean isAboveBottom() {
        return this.subs.contains(this.hierarchy.getBottom());
    }

    @Override
    public boolean isBelowTop() {
        return this.supers.contains(this.hierarchy.getTop());
    }

    @Override
    public <V> V removeData(DataKey<V> key) {
        return (V)this.dataMap.remove(key);
    }

    @Override
    public <V> void removeData(DataKey<V> key, Direction propogate) {
        this.dataMap.remove(key);
        if (propogate != Direction.NONE) {
            UnmodifiableIterator<HierarchyNode<T>> i = this.nodeIterator().excludeBegin().direction(propogate).build();
            while (i.hasNext()) {
                ((HierarchyNode)i.next()).removeData(key);
            }
        }
    }

    @Override
    public <V> void setData(DataKey<V> key, V value) {
        this.dataMap.set(key, value);
    }

    @Override
    public <V> void setData(DataKey<V> key, V value, Direction propogate) {
        this.dataMap.set(key, value);
        if (propogate != Direction.NONE) {
            UnmodifiableIterator<HierarchyNode<T>> i = this.nodeIterator().excludeBegin().direction(propogate).build();
            while (i.hasNext()) {
                ((HierarchyNode)i.next()).setData(key, value);
            }
        }
    }

    void diconnect() {
        Iterator<HierarchyNode<T>> j = this.subs.iterator();
        while (j.hasNext()) {
            HierarchyNodeImpl sub = (HierarchyNodeImpl)j.next();
            j.remove();
            sub.supers.remove(this);
        }
        j = this.supers.iterator();
        while (j.hasNext()) {
            HierarchyNodeImpl sup = (HierarchyNodeImpl)j.next();
            j.remove();
            sup.subs.remove(this);
        }
    }

    @Override
    public void print() {
        HierarchyUtils.printHierarchy(this, (OutputStream)System.out);
    }

    public String toString() {
        return this.elements.toString();
    }
}

