/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.hierarchy.impl;

import com.clarkparsia.pellet.hierarchy.Hierarchy;
import com.clarkparsia.pellet.hierarchy.HierarchyNode;
import com.clarkparsia.pellet.hierarchy.HierarchyUtils;
import com.clarkparsia.pellet.hierarchy.impl.HierarchyNodeImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HierarchyImpl<T>
implements Hierarchy<T> {
    protected Map<T, HierarchyNode<T>> nodes;
    private int size;
    private HierarchyNode<T> top;
    private HierarchyNode<T> bottom;

    public HierarchyImpl(T top, T bottom) {
        this.top = HierarchyNodeImpl.createTop(this, top);
        this.bottom = HierarchyNodeImpl.createBottom(this, bottom);
        this.top.addSub(this.bottom);
        this.nodes = Maps.newHashMap();
        this.nodes.put(top, this.top);
        this.nodes.put(bottom, this.bottom);
        this.size = 2;
    }

    @Override
    public boolean add(T element) {
        int oldSize = this.size();
        this.addNode(element);
        return this.size() != oldSize;
    }

    protected HierarchyNode<T> addNode(T element) {
        HierarchyNode<T> node = this.nodes.get(element);
        if (node == null) {
            node = HierarchyNodeImpl.createNode(this, element);
            this.nodes.put(element, node);
            this.top.addSub(node);
            this.top.removeSub(this.bottom);
            node.addSub(this.bottom);
            ++this.size;
        }
        return node;
    }

    @Override
    public boolean addEquivalent(T element, T newElement) {
        HierarchyNode<T> node1 = this.get(element);
        HierarchyNode<T> node2 = this.get(newElement);
        if (node1 == null) {
            if (node2 == null) {
                this.addNode(element).addElement(newElement);
            } else {
                node2.addElement(element);
            }
        } else if (node2 == null) {
            node1.addElement(newElement);
        } else if (node1 != node2) {
            HierarchyUtils.merge(this, ImmutableList.of(node1, node2));
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean addEquivalent(Iterable<T> elements) {
        ArrayList newElements = Lists.newArrayList();
        ArrayList nodes = Lists.newArrayList();
        for (T element : elements) {
            HierarchyNode<T> node = this.get(element);
            if (node == null) {
                newElements.add(element);
                continue;
            }
            nodes.add(node);
        }
        int nodesSize = nodes.size();
        HierarchyNode node = null;
        if (nodesSize == 0) {
            if (newElements.isEmpty()) {
                return false;
            }
            node = this.addNode(newElements.get(0));
        } else {
            node = nodesSize == 1 ? (HierarchyNode)nodes.get(0) : HierarchyUtils.merge(this, nodes);
        }
        for (Object newElement : newElements) {
            node.addElement(newElement);
        }
        return nodesSize != 1 || newElements.size() > 0;
    }

    @Override
    public boolean addSubNodeOf(T sub, T sup) {
        HierarchyNode<T> parent = this.getExisting(sup);
        HierarchyNode<T> child = this.getExisting(sub);
        return parent.addSub(child);
    }

    @Override
    public boolean removeSubNodeOf(T sub, T sup) {
        HierarchyNode<T> parent = this.get(sup);
        HierarchyNode<T> child = this.get(sub);
        return parent.removeSub(child);
    }

    @Override
    public boolean contains(T element) {
        return this.nodes.containsKey(element);
    }

    @Override
    public HierarchyNode<T> get(T element) {
        return this.nodes.get(element);
    }

    protected HierarchyNode<T> getExisting(T element) {
        HierarchyNode<T> node = this.nodes.get(element);
        Preconditions.checkArgument((node != null ? 1 : 0) != 0, (String)"Element does not exist: %s", element);
        return node;
    }

    @Override
    public HierarchyNode<T> getBottom() {
        return this.bottom;
    }

    @Override
    public Set<T> getEquivalents(T element) {
        HierarchyNode<T> node = this.get(element);
        return node == null ? ImmutableSet.of() : node.getElements();
    }

    @Override
    public Iterable<HierarchyNode<T>> getSubs(T element) {
        HierarchyNode<T> node = this.get(element);
        return node == null ? ImmutableSet.of() : node.nodeIterator().excludeBegin().buildIterable();
    }

    @Override
    public Iterable<HierarchyNode<T>> getDirectSubs(T element) {
        HierarchyNode<T> node = this.get(element);
        return node == null ? ImmutableSet.of() : node.getSubs();
    }

    @Override
    public Iterable<HierarchyNode<T>> getSupers(T element) {
        HierarchyNode<T> node = this.get(element);
        return node == null ? ImmutableSet.of() : node.nodeIterator().bottomUp().excludeBegin().buildIterable();
    }

    @Override
    public Iterable<HierarchyNode<T>> getDirectSupers(T element) {
        HierarchyNode<T> node = this.get(element);
        return node == null ? ImmutableSet.of() : node.getSupers();
    }

    @Override
    public HierarchyNode<T> getTop() {
        return this.top;
    }

    @Override
    public boolean add(T element, Collection<HierarchyNode<T>> subs, Collection<HierarchyNode<T>> sups) {
        if (this.nodes.containsKey(element)) {
            return false;
        }
        HierarchyNode<T> node = HierarchyNodeImpl.createNode(this, element);
        this.nodes.put(element, node);
        if (sups.isEmpty()) {
            sups = ImmutableList.of(this.top);
        }
        for (HierarchyNode<T> sup : sups) {
            sup.addSub(node);
            sup.removeSub(this.bottom);
            for (HierarchyNode sub : subs) {
                sup.removeSub(sub);
            }
        }
        if (subs.isEmpty()) {
            subs = ImmutableList.of(this.bottom);
        }
        for (HierarchyNode<T> sub : subs) {
            node.addSub(sub);
        }
        ++this.size;
        return true;
    }

    @Override
    public HierarchyNode<T> createExternalNode(Iterable<HierarchyNode<T>> subs, Collection<HierarchyNode<T>> sups) {
        return HierarchyNodeImpl.createImmutableNode(this, subs, sups);
    }

    @Override
    public boolean isEquivalent(T element1, T element2) {
        HierarchyNode<T> node = this.get(element1);
        return node != null && node.getElements().contains(element2);
    }

    @Override
    public boolean isSubNodeOf(T sub, T sup) {
        HierarchyNode<T> subNode = this.get(sub);
        HierarchyNode<T> supNode = this.get(sup);
        return subNode != null && supNode != null && Iterators.any(subNode.nodeIterator().bottomUp().build(), (Predicate)Predicates.equalTo(supNode));
    }

    @Override
    public Iterator<HierarchyNode<T>> iterator() {
        return this.top.nodeIterator().build();
    }

    @Override
    public boolean remove(T element) {
        HierarchyNode<T> node = this.get(element);
        if (node == null) {
            return false;
        }
        if (node.getElements().size() > 1) {
            node.removeElement(element);
        } else {
            this.remove(node);
        }
        return true;
    }

    @Override
    public boolean remove(HierarchyNode<T> node) {
        int keyCount = this.nodes.size();
        for (Object element : node) {
            this.nodes.remove(element);
        }
        if (keyCount == this.nodes.size()) {
            return false;
        }
        this.disconnect(node);
        --this.size;
        return true;
    }

    @Override
    public Set<T> getElements() {
        return this.nodes.keySet();
    }

    @Override
    public int size() {
        return this.size;
    }

    protected void disconnect(HierarchyNode<T> node) {
        if (node instanceof HierarchyNodeImpl) {
            ((HierarchyNodeImpl)node).diconnect();
        } else {
            for (HierarchyNode sub : Lists.newArrayList(node.getSubs())) {
                node.removeSub(sub);
            }
            for (HierarchyNode sup : Lists.newArrayList(node.getSupers())) {
                sup.removeSub(node);
            }
        }
    }
}

