/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.hierarchy;

import com.clarkparsia.pellet.hierarchy.Direction;
import com.clarkparsia.pellet.hierarchy.Hierarchy;
import com.clarkparsia.pellet.hierarchy.HierarchyNode;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class HierarchyIterator<T> {
    private Itr<T> iterator;

    private HierarchyIterator(HierarchyNode<T> beginNode) {
        this.iterator = new Itr<T>(beginNode);
    }

    public static <T> HierarchyIterator<T> create(HierarchyNode<T> beginNode) {
        return new HierarchyIterator<T>(beginNode);
    }

    public HierarchyIterator<T> bottomUp() {
        this.iterator.bottomUp = true;
        return this;
    }

    public HierarchyIterator<T> topDown() {
        this.iterator.bottomUp = false;
        return this;
    }

    public HierarchyIterator<T> direction(Direction direction) {
        Preconditions.checkArgument((direction != Direction.NONE ? 1 : 0) != 0, (Object)"Invalid iteration direction: Direction.NONE");
        this.iterator.bottomUp = direction == Direction.UP;
        return this;
    }

    public HierarchyIterator<T> excludeEnd() {
        this.iterator.excludeEnd = true;
        return this;
    }

    public HierarchyIterator<T> excludeBegin() {
        this.iterator.excludeBegin = true;
        return this;
    }

    public HierarchyIterator<T> allowDuplicates() {
        this.iterator.allowDuplicates = true;
        return this;
    }

    public UnmodifiableIterator<HierarchyNode<T>> build() {
        this.iterator.init();
        return this.iterator;
    }

    public <F> Iterator<F> build(Function<HierarchyNode<T>, F> function) {
        return Iterators.transform(this.build(), function);
    }

    public Iterable<HierarchyNode<T>> buildIterable() {
        return new Iterable<HierarchyNode<T>>(){

            @Override
            public Iterator<HierarchyNode<T>> iterator() {
                Itr itr = HierarchyIterator.this.iterator.copy();
                itr.init();
                return itr;
            }
        };
    }

    public <F> Iterable<F> buildIterable(Function<HierarchyNode<T>, F> function) {
        return Iterables.transform(this.buildIterable(), function);
    }

    public List<HierarchyNode<T>> buildList() {
        return Lists.newArrayList(this.build());
    }

    public <F> List<F> buildList(Function<HierarchyNode<T>, F> function) {
        return Lists.newArrayList(this.build(function));
    }

    public Set<HierarchyNode<T>> buildSet() {
        return Sets.newHashSet(this.build());
    }

    public <F> Set<F> buildSet(Function<HierarchyNode<T>, F> function) {
        return Sets.newHashSet(this.build(function));
    }

    private static class Itr<T>
    extends UnmodifiableIterator<HierarchyNode<T>> {
        private List<HierarchyNode<T>> pending;
        private Set<HierarchyNode<T>> visited;
        private HierarchyNode<T> beginNode;
        private boolean bottomUp = false;
        private boolean excludeBegin = false;
        private boolean excludeEnd = false;
        private boolean allowDuplicates = false;

        public Itr(HierarchyNode<T> beginNode) {
            this.beginNode = beginNode;
        }

        private Itr<T> copy() {
            Itr<T> copy = new Itr<T>(this.beginNode);
            copy.bottomUp = this.bottomUp;
            copy.excludeBegin = this.excludeBegin;
            copy.excludeEnd = this.excludeEnd;
            copy.allowDuplicates = this.allowDuplicates;
            return copy;
        }

        private void init() {
            this.visited = Sets.newHashSet();
            this.pending = Lists.newArrayList();
            this.pending.add(this.beginNode);
            if (this.excludeEnd) {
                Hierarchy<T> hierarchy = this.beginNode.getHierarchy();
                if (this.bottomUp) {
                    this.visited.add(hierarchy.getTop());
                } else {
                    this.visited.add(hierarchy.getBottom());
                }
            }
            if (this.excludeBegin) {
                this.next();
            }
        }

        public boolean hasNext() {
            return !this.pending.isEmpty();
        }

        public HierarchyNode<T> next() {
            if (this.pending.isEmpty()) {
                throw new NoSuchElementException();
            }
            HierarchyNode<T> current = this.pending.remove(this.pending.size() - 1);
            if (!this.allowDuplicates) {
                this.visited.add(current);
            }
            Collection<HierarchyNode<T>> nextNodes = this.bottomUp ? current.getSupers() : current.getSubs();
            for (HierarchyNode hierarchyNode : nextNodes) {
                if (this.visited.contains(hierarchyNode)) continue;
                this.pending.add(hierarchyNode);
            }
            return current;
        }
    }
}

