/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.function.AbstractFunction;
import com.clarkparsia.pellet.function.FunctionArgs;

public abstract class ValueFunction
extends AbstractFunction {
    @Override
    public Entity eval(FunctionArgs args) {
        this.assertArity(args);
        return this.internalEval(args);
    }

    @Override
    public boolean evalBool(FunctionArgs args) {
        Entity e = this.eval(args);
        if (e == null) {
            throw new IllegalArgumentException("Cannot determine boolean effective value of a null value");
        }
        if (!(e instanceof LiteralValue)) {
            throw new IllegalArgumentException("Cannot determine boolean effective value of a non-literal");
        }
        Boolean value = Literals.getBooleanValue((LiteralValue)e);
        if (value == null) {
            throw new IllegalArgumentException("Indeterminate boolean effective value");
        }
        return value;
    }

    protected abstract Entity internalEval(FunctionArgs var1);
}

