/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.function.BooleanFunction;
import com.clarkparsia.pellet.function.FunctionArgs;
import com.clarkparsia.pellet.function.FunctionEvaluator;
import com.clarkparsia.pellet.function.StringFunction;
import com.clarkparsia.pellet.function.ValueFunction;
import jakarta.xml.bind.DatatypeConverter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringFunctions {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringFunctions.class);
    public static final BooleanFunction CONTAINS = new Contains();
    public static final BooleanFunction CONTAINS_IGNORE_CASE = new ContainsIgnoreCase();
    public static final BooleanFunction ENDS_WITH = new EndsWith();
    public static final StringFunction LOWER_CASE = new LowerCase();
    public static final BooleanFunction MATCHES = new Matches();
    public static final StringFunction NORMALIZE_SPACE = new NormalizeSpace();
    public static final StringFunction REPLACE = new Replace();
    public static final BooleanFunction STARTS_WITH = new StartsWith();
    public static final StringFunction STRING_CONCAT = new StringConcat();
    public static final BooleanFunction STRING_EQUAL_IGNORE_CASE = new StringEqualIgnoreCase();
    public static final FunctionEvaluator STRING_LENGTH = new StringLength();
    public static final StringFunction SUBSTRING = new SubString();
    public static final StringFunction SUBSTRING_AFTER = new SubStringAfter();
    public static final StringFunction SUBSTRING_BEFORE = new SubStringBefore();
    public static final StringFunction TRANSLATE = new Translate();
    public static final StringFunction UPPER_CASE = new UpperCase();

    private static class Contains
    extends BooleanFunction {
        private Contains() {
        }

        @Override
        public Function getFunction() {
            return Functions.CONTAINS;
        }

        @Override
        public boolean internalEval(FunctionArgs args) {
            String l1str = args.getString(0);
            String l2str = args.getString(1);
            return l1str.contains(l2str);
        }
    }

    private static class ContainsIgnoreCase
    extends BooleanFunction {
        private ContainsIgnoreCase() {
        }

        @Override
        public Function getFunction() {
            return Functions.CONTAINS_IGNORE_CASE;
        }

        @Override
        public boolean internalEval(FunctionArgs args) {
            String l1str = args.getString(0).toLowerCase();
            String l2str = args.getString(1).toLowerCase();
            return l1str.contains(l2str);
        }
    }

    private static class EndsWith
    extends BooleanFunction {
        private EndsWith() {
        }

        @Override
        public Function getFunction() {
            return Functions.ENDS_WITH;
        }

        @Override
        public boolean internalEval(FunctionArgs args) {
            String l1str = args.getString(0);
            String l2str = args.getString(1);
            return l1str.endsWith(l2str);
        }
    }

    private static class LowerCase
    extends StringFunction {
        private LowerCase() {
        }

        @Override
        public Function getFunction() {
            return Functions.LOWER_CASE;
        }

        @Override
        protected String internalEvalString(FunctionArgs args) {
            return args.getString(0).toLowerCase();
        }
    }

    private static class Matches
    extends BooleanFunction {
        private Matches() {
        }

        @Override
        public Function getFunction() {
            return Functions.MATCHES;
        }

        @Override
        public boolean internalEval(FunctionArgs args) {
            String l1str = args.getString(0);
            String l2str = args.getString(1);
            boolean result = false;
            try {
                result = Pattern.compile(l2str).matcher(l1str).find();
            }
            catch (PatternSyntaxException e) {
                LOGGER.warn("Bad regex: " + l2str);
            }
            return result;
        }
    }

    private static class NormalizeSpace
    extends StringFunction {
        private NormalizeSpace() {
        }

        @Override
        public Function getFunction() {
            return Functions.NORMALIZE_SPACE;
        }

        @Override
        protected String internalEvalString(FunctionArgs args) {
            return args.getString(0).trim().replaceAll("\\s+", " ");
        }
    }

    private static class Replace
    extends StringFunction {
        private Replace() {
        }

        @Override
        public Function getFunction() {
            return Functions.REPLACE;
        }

        @Override
        protected String internalEvalString(FunctionArgs args) {
            String from = args.getString(1);
            String to = args.getString(2);
            return args.getString(0).replace(from, to);
        }
    }

    private static class StartsWith
    extends BooleanFunction {
        private StartsWith() {
        }

        @Override
        public Function getFunction() {
            return Functions.STARTS_WITH;
        }

        @Override
        public boolean internalEval(FunctionArgs args) {
            String l1str = args.getString(0);
            String l2str = args.getString(1);
            return l1str.startsWith(l2str);
        }
    }

    private static class StringConcat
    extends StringFunction {
        private StringConcat() {
        }

        @Override
        public Function getFunction() {
            return Functions.STRING_CONCAT;
        }

        @Override
        protected String internalEvalString(FunctionArgs args) {
            StringBuffer resultBuffer = new StringBuffer();
            for (int i = 0; i < args.size(); ++i) {
                resultBuffer.append(args.getString(i));
            }
            return resultBuffer.toString();
        }
    }

    private static class StringEqualIgnoreCase
    extends BooleanFunction {
        private StringEqualIgnoreCase() {
        }

        @Override
        public Function getFunction() {
            return Functions.STRING_EQUAL_IGNORE_CASE;
        }

        @Override
        public boolean internalEval(FunctionArgs args) {
            String l1str = args.getString(0);
            String l2str = args.getString(1);
            return l1str.equalsIgnoreCase(l2str);
        }
    }

    private static class StringLength
    extends ValueFunction {
        private StringLength() {
        }

        @Override
        public Function getFunction() {
            return Functions.STRING_LENGTH;
        }

        @Override
        public LiteralValue internalEval(FunctionArgs args) {
            return TermFactory.literal(args.getString(0).length());
        }
    }

    private static class SubString
    extends StringFunction {
        private SubString() {
        }

        @Override
        public Function getFunction() {
            return Functions.SUBSTRING;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            long beginIndex = 0L;
            long endIndex = args.getString(0).length();
            try {
                double beginDouble = DatatypeConverter.parseDouble((String)args.getString(1));
                long begin = Double.isNaN(beginDouble) || beginDouble > 2.147483647E9 ? Integer.MAX_VALUE : Math.round(beginDouble);
                long count = Integer.MAX_VALUE;
                if (args.size() == 3) {
                    double countDouble = DatatypeConverter.parseDouble((String)args.getString(2));
                    count = Double.isNaN(countDouble) || countDouble < 0.0 ? 0L : Math.round(countDouble);
                }
                beginIndex = Math.min((long)args.getString(0).length(), Math.max(0L, begin - 1L));
                endIndex = Math.min((long)args.getString(0).length(), Math.max(beginIndex, begin + count - 1L));
            }
            catch (NumberFormatException e) {
                return "";
            }
            if (beginIndex > Integer.MAX_VALUE) {
                beginIndex = Integer.MAX_VALUE;
            }
            if (endIndex > Integer.MAX_VALUE) {
                endIndex = Integer.MAX_VALUE;
            }
            return args.getString(0).substring((int)beginIndex, (int)endIndex);
        }
    }

    private static class SubStringAfter
    extends StringFunction {
        private SubStringAfter() {
        }

        @Override
        public Function getFunction() {
            return Functions.SUBSTRING_AFTER;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            if (args.getString(1).equals("")) {
                return args.getString(0);
            }
            int index = args.getString(0).indexOf(args.getString(1));
            if (index < 0) {
                return "";
            }
            return args.getString(0).substring(index + args.getString(1).length());
        }
    }

    private static class SubStringBefore
    extends StringFunction {
        private SubStringBefore() {
        }

        @Override
        public Function getFunction() {
            return Functions.SUBSTRING_BEFORE;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            if (args.getString(1).equals("")) {
                return "";
            }
            int index = args.getString(0).indexOf(args.getString(1));
            if (index < 0) {
                return "";
            }
            return args.getString(0).substring(0, index);
        }
    }

    private static class Translate
    extends StringFunction {
        private Translate() {
        }

        @Override
        public Function getFunction() {
            return Functions.TRANSLATE;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            String src = args.getString(1);
            String dst = args.getString(2);
            StringBuffer result = new StringBuffer();
            for (char c : args.getString(0).toCharArray()) {
                int replPos = src.indexOf(c);
                if (replPos < 0) {
                    result.append(c);
                    continue;
                }
                if (replPos >= dst.length()) continue;
                result.append(dst.charAt(replPos));
            }
            return result.toString();
        }
    }

    private static class UpperCase
    extends StringFunction {
        private UpperCase() {
        }

        @Override
        public Function getFunction() {
            return Functions.UPPER_CASE;
        }

        @Override
        public String internalEvalString(FunctionArgs args) {
            return args.getString(0).toUpperCase();
        }
    }
}

