/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.function.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumericComparisonVisitor
implements NumericVisitor<Integer> {
    private static Integer LESS_THAN = -1;
    private static Integer GREATER_THAN = 1;
    private static Integer EQUAL = 0;

    private void argCheck(Number ... args) {
        if (args.length != 2) {
            throw new RuntimeException("Wrong number of arguments to comparison visitor.");
        }
    }

    @Override
    public Integer apply(BigDecimal ... args) {
        this.argCheck(args);
        return this.comparisonResult(args[0].compareTo(args[1]));
    }

    @Override
    public Integer apply(BigInteger ... args) {
        this.argCheck(args);
        return this.comparisonResult(args[0].compareTo(args[1]));
    }

    @Override
    public Integer apply(Double ... args) {
        this.argCheck(args);
        return this.comparisonResult(args[0].compareTo(args[1]));
    }

    @Override
    public Integer apply(Float ... args) {
        this.argCheck(args);
        return this.comparisonResult(args[0].compareTo(args[1]));
    }

    private Integer comparisonResult(int cmp) {
        return cmp < 0 ? LESS_THAN : (cmp == 0 ? EQUAL : GREATER_THAN);
    }
}

