/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.function.BooleanFunctions;
import com.clarkparsia.pellet.function.ComparisonTesters;
import com.clarkparsia.pellet.function.DateTimeFunctions;
import com.clarkparsia.pellet.function.FunctionEvaluator;
import com.clarkparsia.pellet.function.NumericFunctions;
import com.clarkparsia.pellet.function.StringFunctions;
import com.clarkparsia.pellet.function.URIFunctions;
import com.clarkparsia.pellet.function.UnsupportedFunction;
import com.google.common.collect.Maps;
import java.util.Map;

public class FunctionRegistry {
    private static final Map<Function, FunctionEvaluator> FUNCTIONS = Maps.newHashMap();

    public static FunctionEvaluator getEvaluator(Function name) {
        FunctionEvaluator aEvaluator = FUNCTIONS.get(name);
        if (aEvaluator == null) {
            aEvaluator = UnsupportedFunction.INSTANCE;
        }
        return aEvaluator;
    }

    public static boolean register(FunctionEvaluator builtIn) {
        if (FUNCTIONS.containsKey(builtIn.getFunction())) {
            return false;
        }
        FUNCTIONS.put(builtIn.getFunction(), builtIn);
        return true;
    }

    static {
        FunctionRegistry.register(ComparisonTesters.EQUAL);
        FunctionRegistry.register(ComparisonTesters.GREATER_THAN);
        FunctionRegistry.register(ComparisonTesters.GREATER_THAN_OR_EQUAL);
        FunctionRegistry.register(ComparisonTesters.LESS_THAN);
        FunctionRegistry.register(ComparisonTesters.LESS_THAN_OR_EQUAL);
        FunctionRegistry.register(ComparisonTesters.NOT_EQUAL);
        FunctionRegistry.register(DateTimeFunctions.DATE);
        FunctionRegistry.register(DateTimeFunctions.DATE_TIME);
        FunctionRegistry.register(DateTimeFunctions.DAY_TIME_DURATION);
        FunctionRegistry.register(DateTimeFunctions.TIME);
        FunctionRegistry.register(DateTimeFunctions.YEAR_MONTH_DURATION);
        FunctionRegistry.register(URIFunctions.RESOLVE_URI);
        FunctionRegistry.register(URIFunctions.ANY_URI);
        FunctionRegistry.register(NumericFunctions.ABS);
        FunctionRegistry.register(NumericFunctions.ADD);
        FunctionRegistry.register(NumericFunctions.CEILING);
        FunctionRegistry.register(NumericFunctions.COS);
        FunctionRegistry.register(NumericFunctions.DIVIDE);
        FunctionRegistry.register(NumericFunctions.FLOOR);
        FunctionRegistry.register(NumericFunctions.INTEGER_DIVIDE);
        FunctionRegistry.register(NumericFunctions.MOD);
        FunctionRegistry.register(NumericFunctions.MULTIPLY);
        FunctionRegistry.register(NumericFunctions.POW);
        FunctionRegistry.register(NumericFunctions.ROUND);
        FunctionRegistry.register(NumericFunctions.ROUND_HALF_TO_EVEN);
        FunctionRegistry.register(NumericFunctions.SIN);
        FunctionRegistry.register(NumericFunctions.SUBTRACT);
        FunctionRegistry.register(NumericFunctions.TAN);
        FunctionRegistry.register(NumericFunctions.UNARY_MINUS);
        FunctionRegistry.register(NumericFunctions.UNARY_PLUS);
        FunctionRegistry.register(StringFunctions.CONTAINS);
        FunctionRegistry.register(StringFunctions.CONTAINS_IGNORE_CASE);
        FunctionRegistry.register(StringFunctions.ENDS_WITH);
        FunctionRegistry.register(StringFunctions.LOWER_CASE);
        FunctionRegistry.register(StringFunctions.MATCHES);
        FunctionRegistry.register(StringFunctions.NORMALIZE_SPACE);
        FunctionRegistry.register(StringFunctions.REPLACE);
        FunctionRegistry.register(StringFunctions.STARTS_WITH);
        FunctionRegistry.register(StringFunctions.STRING_CONCAT);
        FunctionRegistry.register(StringFunctions.STRING_EQUAL_IGNORE_CASE);
        FunctionRegistry.register(StringFunctions.STRING_LENGTH);
        FunctionRegistry.register(StringFunctions.SUBSTRING);
        FunctionRegistry.register(StringFunctions.SUBSTRING_AFTER);
        FunctionRegistry.register(StringFunctions.SUBSTRING_BEFORE);
        FunctionRegistry.register(StringFunctions.TRANSLATE);
        FunctionRegistry.register(StringFunctions.UPPER_CASE);
        FunctionRegistry.register(BooleanFunctions.AND);
        FunctionRegistry.register(BooleanFunctions.OR);
        FunctionRegistry.register(BooleanFunctions.NOT);
    }
}

