/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.query.Bindings;
import com.clarkparsia.pellet.api.term.Term;
import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.Variable;
import com.clarkparsia.pellet.api.term.function.Expression;
import com.clarkparsia.pellet.api.term.function.FunctionEval;
import com.clarkparsia.pellet.function.FunctionEvaluator;
import com.clarkparsia.pellet.function.FunctionRegistry;
import com.google.common.base.Function;
import java.util.Arrays;
import java.util.List;

public class FunctionArgs {
    private final List<Expression> args;
    private final Function<? super Variable, Term> binding;

    public FunctionArgs(Function<? super Variable, Term> binding, List<Expression> args) {
        this.args = args;
        this.binding = binding;
    }

    public FunctionArgs(List<Expression> args) {
        this((Function<? super Variable, Term>)Bindings.empty(), args);
    }

    public FunctionArgs(Function<? super Variable, Term> binding, Expression ... args) {
        this(binding, Arrays.asList(args));
    }

    public FunctionArgs(Expression ... args) {
        this((Function<? super Variable, Term>)Bindings.empty(), args);
    }

    public FunctionArgs(Function<? super Variable, Term> binding, FunctionEval eval) {
        this(binding, (List<Expression>)eval.getArgs());
    }

    public FunctionArgs(FunctionEval eval) {
        this((Function<? super Variable, Term>)Bindings.empty(), eval);
    }

    public Entity get(int index) {
        Term t;
        Expression arg = this.args.get(index);
        if (arg instanceof FunctionEval) {
            FunctionEval fe = (FunctionEval)arg;
            FunctionEvaluator f = FunctionRegistry.getEvaluator(fe.getFunction());
            return f.eval(new FunctionArgs(this.binding, (List<Expression>)fe.getArgs()));
        }
        Entity e = (Entity)arg;
        if (e.isVariable() && (t = (Term)this.binding.apply((Object)((Variable)e))) != null) {
            e = (Entity)t;
        }
        return e;
    }

    public LiteralValue getLiteral(int index) {
        return (LiteralValue)this.get(index);
    }

    public String getString(int index) {
        return ((Literal)this.get(index)).getLexicalValue();
    }

    public Object getObject(int index) {
        return Literals.getValue(this.getLiteral(index));
    }

    public Number getNumber(int index) {
        return (Number)this.getObject(index);
    }

    public boolean getBoolean(int index) {
        return (Boolean)Literals.getValue(this.getLiteral(index));
    }

    public int size() {
        return this.args.size();
    }
}

