/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.builtins.Facets;
import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.LiteralValue;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.function.BooleanFunction;
import com.clarkparsia.pellet.function.FunctionArgs;
import com.clarkparsia.pellet.function.NumericComparisonVisitor;
import com.clarkparsia.pellet.function.NumericPromotion;
import com.google.common.base.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComparisonTesters {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComparisonTesters.class);
    public static final BooleanFunction EQUAL = new EqualityTester(Functions.EQUAL, false);
    public static final BooleanFunction GREATER_THAN = new OrderingTester(Functions.GREATER_THAN, false, false);
    public static final BooleanFunction GREATER_THAN_OR_EQUAL = new OrderingTester(Functions.GREATER_THAN_OR_EQUAL, false, true);
    public static final BooleanFunction LESS_THAN = new OrderingTester(Functions.LESS_THAN, true, false);
    public static final BooleanFunction LESS_THAN_OR_EQUAL = new OrderingTester(Functions.LESS_THAN_OR_EQUAL, true, true);
    public static final BooleanFunction NOT_EQUAL = new EqualityTester(Functions.NOT_EQUAL, true);

    private static class EqualityTester
    extends BooleanFunction {
        private final Function function;
        private boolean flip;

        private EqualityTester(Function function, boolean flip) {
            this.function = function;
            this.flip = flip;
        }

        @Override
        public Function getFunction() {
            return this.function;
        }

        @Override
        protected boolean internalEval(FunctionArgs args) {
            Object aval = args.getObject(0);
            Object bval = args.getObject(1);
            if (aval instanceof Number && bval instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number anum = (Number)aval;
                Number bnum = (Number)bval;
                promoter.promote(anum, bnum);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                int cmp = promoter.accept(visitor);
                if (cmp == 0) {
                    return true ^ this.flip;
                }
                return false ^ this.flip;
            }
            if (aval != null && bval != null) {
                return (aval.getClass().equals(bval.getClass()) && aval.equals(bval)) ^ this.flip;
            }
            return false;
        }
    }

    private static class OrderingTester
    extends BooleanFunction {
        private final Function function;
        private final boolean lt;
        private final boolean inclusive;

        private OrderingTester(Function function, boolean flip, boolean inclusive) {
            this.function = function;
            this.lt = flip;
            this.inclusive = inclusive;
        }

        @Override
        public Function getFunction() {
            return this.function;
        }

        private boolean comparesWell(int comparison) {
            if (this.lt && comparison < 0) {
                return true;
            }
            if (!this.lt && comparison > 0) {
                return true;
            }
            return this.inclusive && comparison == 0;
        }

        @Override
        protected boolean internalEval(FunctionArgs args) {
            LiteralValue l1 = args.getLiteral(0);
            LiteralValue l2 = args.getLiteral(1);
            Object l1val = Literals.getValue(l1);
            Object l2val = Literals.getValue(l2);
            if (l1.isVariable() || l2.isVariable()) {
                return false;
            }
            if (l1val instanceof Literal) {
                if (l2val instanceof Literal) {
                    Literal lit1 = (Literal)l1val;
                    Literal lit2 = (Literal)l2val;
                    String l1str = lit1.getLexicalValue();
                    String l2str = lit2.getLexicalValue();
                    String l1lang = lit1.getLanguage();
                    String l2lang = lit2.getLanguage();
                    String l1data = lit1.getDatatype().getName();
                    String l2data = lit2.getDatatype().getName();
                    if (Objects.equal((Object)l1lang, (Object)l2lang) && Objects.equal((Object)l1data, (Object)l2data)) {
                        return this.comparesWell(l1str.compareTo(l2str));
                    }
                }
                return false;
            }
            if (l2val instanceof Literal) {
                return false;
            }
            if (l1val instanceof Number && l2val instanceof Number) {
                NumericPromotion promoter = new NumericPromotion();
                Number l1num = (Number)l1val;
                Number l2num = (Number)l2val;
                promoter.promote(l1num, l2num);
                NumericComparisonVisitor visitor = new NumericComparisonVisitor();
                Integer cmp = promoter.accept(visitor);
                return this.comparesWell(cmp);
            }
            NamedDatatype type1 = ((Literal)l1).getDatatype();
            try {
                Datatype<?> d1 = DatatypeReasonerImpl.coreDatatypes.get(type1).getPrimitiveDatatype();
                Facets f = this.lt ? (this.inclusive ? Facets.MAX_INCLUSIVE : Facets.MAX_EXCLUSIVE) : (this.inclusive ? Facets.MIN_INCLUSIVE : Facets.MIN_EXCLUSIVE);
                RestrictedDataRange<?> dr = d1.asDataRange().applyConstrainingFacet(f, l2val);
                return dr.contains(l1val);
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected datatype reasoner exception comparaing two literals ('{}','{}'). Treating as incomparable.", (Object)l1, (Object)l2);
                return false;
            }
        }
    }
}

