/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.function;

import com.clarkparsia.pellet.api.term.builtins.Functions;
import com.clarkparsia.pellet.api.term.builtins.Literals;
import com.clarkparsia.pellet.api.term.entity.Entity;
import com.clarkparsia.pellet.api.term.function.Function;
import com.clarkparsia.pellet.function.BooleanFunction;
import com.clarkparsia.pellet.function.FunctionArgs;
import com.clarkparsia.pellet.function.FunctionEvaluator;
import com.clarkparsia.pellet.function.ValueFunction;

public class BooleanFunctions {
    public static final FunctionEvaluator NOT = new BooleanNot();
    public static final FunctionEvaluator AND = new BooleanAnd();
    public static final FunctionEvaluator OR = new BooleanOr();

    private static class BooleanNot
    extends BooleanFunction {
        private BooleanNot() {
        }

        @Override
        public Function getFunction() {
            return Functions.NOT;
        }

        @Override
        public boolean internalEval(FunctionArgs args) {
            return !args.getBoolean(0);
        }
    }

    private static class BooleanAnd
    extends ValueFunction {
        private BooleanAnd() {
        }

        @Override
        public Function getFunction() {
            return Functions.AND;
        }

        @Override
        protected Entity internalEval(FunctionArgs args) {
            for (int i = 0; i < args.size(); ++i) {
                if (args.getBoolean(i)) continue;
                return Literals.FALSE;
            }
            return Literals.TRUE;
        }
    }

    private static class BooleanOr
    extends ValueFunction {
        private BooleanOr() {
        }

        @Override
        public Function getFunction() {
            return Functions.OR;
        }

        @Override
        protected Entity internalEval(FunctionArgs args) {
            for (int i = 0; i < args.size(); ++i) {
                if (!args.getBoolean(i)) continue;
                return Literals.TRUE;
            }
            return Literals.FALSE;
        }
    }
}

