/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.uri;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RestrictedURIDataRange
implements RestrictedDataRange<Literal> {
    private final Datatype<Literal> dt;
    private final Set<Object> excludedValues;

    public RestrictedURIDataRange(Datatype<Literal> dt) {
        this(dt, Collections.emptySet());
    }

    private RestrictedURIDataRange(Datatype<Literal> dt, Set<Object> excludedValues) {
        this.dt = dt;
        this.excludedValues = excludedValues;
    }

    @Override
    public RestrictedDataRange<Literal> applyConstrainingFacet(Facet facet, Object value) throws InvalidConstrainingFacetException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Literal) {
            Literal a = (Literal)value;
            if (this.excludedValues.contains(a)) {
                return false;
            }
            if (Datatypes.ANY_URI.equals(a.getDatatype())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDataRange<Literal> exclude(Collection<?> values) {
        HashSet<Object> newExcludedValues = new HashSet<Object>(values);
        newExcludedValues.addAll(this.excludedValues);
        return new RestrictedURIDataRange(this.dt, newExcludedValues);
    }

    @Override
    public Datatype<? extends Literal> getDatatype() {
        return this.dt;
    }

    @Override
    public Literal getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDataRange<Literal> intersect(RestrictedDataRange<?> other, boolean negated) {
        if (other instanceof RestrictedURIDataRange) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public RestrictedDataRange<Literal> union(RestrictedDataRange<?> other) {
        if (other instanceof RestrictedURIDataRange) {
            return this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Literal> valueIterator() {
        throw new IllegalStateException();
    }
}

