/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.text;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Facet;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public class RestrictedTextDataRange
implements RestrictedDataRange<Literal> {
    private static final String NCNAMESTARTCHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NCNAMECHAR = "[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NCNAME = "([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])([A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    private static final String NAMESTARTCHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]";
    private static final String NAMECHAR = ":|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040]";
    protected static final String NAME = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd])(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])*";
    protected static final String NMTOKEN = "(:|[A-Z]|_|[a-z]|[\u00c0-\u00d6]|[\u00d8-\u00f6]|[\u00f8-\u02ff]|[\u0370-\u037d]|[\u037f-\u1fff]|[\u200c-\u200d]|[\u2070-\u218f]|[\u2c00-\u2fef]|[\u3001-\ud7ff]|[\uf900-\ufdcf]|[\ufdf0-\ufffd]|-|\\.|[0-9]|\u00b7|[\u0300-\u036f]|[\u203f-\u2040])+";
    protected static final String TOKEN = "([^\\s])(\\s([^\\s])|([^\\s]))*";
    protected static final String LANGUAGE = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";
    protected static final String NORMALIZED_STRING = "([^\\r\\n\\t])*";
    private static final Set<NamedDatatype> permittedDts = Sets.newHashSet((Object[])new NamedDatatype[]{Datatypes.STRING});
    private final Set<Object> excludedValues;
    private final Pattern pattern;
    private final boolean allowLang;
    private final Datatype<Literal> dt;

    public static boolean addPermittedDatatype(NamedDatatype dt) {
        return permittedDts.add(dt);
    }

    public RestrictedTextDataRange(Datatype<Literal> dt, boolean allowLang) {
        this(dt, null, allowLang, Collections.emptySet());
    }

    public RestrictedTextDataRange(Datatype<Literal> dt, String pattern) {
        this(dt, Pattern.compile(pattern), false, Collections.emptySet());
    }

    private RestrictedTextDataRange(Datatype<Literal> dt, Pattern pattern, boolean allowLang, Set<Object> excludedValues) {
        this.dt = dt;
        this.allowLang = allowLang;
        this.excludedValues = excludedValues;
        this.pattern = pattern;
    }

    @Override
    public RestrictedDataRange<Literal> applyConstrainingFacet(Facet facet, Object value) throws InvalidConstrainingFacetException {
        return this;
    }

    @Override
    public boolean contains(Object value) {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            if (this.excludedValues.contains(literal)) {
                return false;
            }
            if (permittedDts.contains(literal.getDatatype())) {
                if (!this.allowLang && literal.hasLanguage()) {
                    return false;
                }
                return this.pattern == null || this.pattern.matcher(literal.getLexicalValue()).matches();
            }
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(int n) {
        return true;
    }

    @Override
    public RestrictedDataRange<Literal> exclude(Collection<?> values) {
        HashSet<Object> newExcludedValues = new HashSet<Object>(values);
        newExcludedValues.addAll(this.excludedValues);
        return new RestrictedTextDataRange(this.dt, this.pattern, this.allowLang, newExcludedValues);
    }

    @Override
    public Datatype<? extends Literal> getDatatype() {
        return this.dt;
    }

    @Override
    public Literal getValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RestrictedDataRange<Literal> intersect(RestrictedDataRange<?> other, boolean negated) {
        if (other instanceof RestrictedTextDataRange) {
            if (this.pattern != null || ((RestrictedTextDataRange)other).pattern != null) {
                throw new UnsupportedOperationException();
            }
            if (!this.allowLang) {
                return this;
            }
            return (RestrictedTextDataRange)other;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isEnumerable() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        throw new IllegalStateException();
    }

    @Override
    public RestrictedDataRange<Literal> union(RestrictedDataRange<?> other) {
        if (other instanceof RestrictedTextDataRange) {
            if (this.pattern != null || ((RestrictedTextDataRange)other).pattern != null) {
                throw new UnsupportedOperationException();
            }
            if (this.allowLang) {
                return this;
            }
            return (RestrictedTextDataRange)other;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Iterator<Literal> valueIterator() {
        throw new IllegalStateException();
    }
}

