/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;

public class XSDUnsignedByte
extends AbstractDerivedIntegerType {
    private static final XSDUnsignedByte instance;
    public static final short MAX_VALUE;

    public static XSDUnsignedByte getInstance() {
        return instance;
    }

    private XSDUnsignedByte() {
        super(Datatypes.UNSIGNED_BYTE, 0, MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            short i = DatatypeConverter.parseShort((String)lexicalForm);
            if (i < 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            if (i > MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }

    static {
        MAX_VALUE = (short)255;
        instance = new XSDUnsignedByte();
    }
}

