/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;
import java.math.BigInteger;

public class XSDNegativeInteger
extends AbstractDerivedIntegerType {
    private static final XSDNegativeInteger instance = new XSDNegativeInteger();

    public static XSDNegativeInteger getInstance() {
        return instance;
    }

    private XSDNegativeInteger() {
        super(Datatypes.NEGATIVE_INTEGER, null, -1);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            BigInteger n = DatatypeConverter.parseInteger((String)lexicalForm);
            if (BigInteger.ZERO.compareTo(n) <= 0) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

