/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;

public class XSDLong
extends AbstractDerivedIntegerType {
    private static final XSDLong instance = new XSDLong();

    public static XSDLong getInstance() {
        return instance;
    }

    private XSDLong() {
        super(Datatypes.LONG, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            return DatatypeConverter.parseLong((String)lexicalForm);
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

