/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.AbstractDerivedIntegerType;
import jakarta.xml.bind.DatatypeConverter;

public class XSDInt
extends AbstractDerivedIntegerType {
    private static final XSDInt instance = new XSDInt();

    public static XSDInt getInstance() {
        return instance;
    }

    private XSDInt() {
        super(Datatypes.INT, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected Number fromLexicalForm(String lexicalForm) throws InvalidLiteralException {
        try {
            long n = DatatypeConverter.parseLong((String)lexicalForm);
            if (n < Integer.MIN_VALUE || n > Integer.MAX_VALUE) {
                throw new InvalidLiteralException(this.getName(), lexicalForm);
            }
            return (int)n;
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), lexicalForm);
        }
    }
}

