/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.real;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.api.term.entity.NamedDatatype;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.real.IntegerInterval;
import com.clarkparsia.pellet.datatypes.types.real.RestrictedRealDataRange;
import com.clarkparsia.pellet.datatypes.types.real.XSDDecimal;

public abstract class AbstractDerivedIntegerType
extends AbstractBaseDatatype<Number> {
    private static final XSDDecimal XSD_DECIMAL = XSDDecimal.getInstance();
    private final RestrictedDataRange<Number> dataRange;

    public AbstractDerivedIntegerType(NamedDatatype name, Number lower, Number upper) {
        super(name);
        if (lower != null && !OWLRealUtils.isInteger(lower)) {
            throw new IllegalArgumentException();
        }
        if (upper != null && !OWLRealUtils.isInteger(upper)) {
            throw new IllegalArgumentException();
        }
        if (lower != null && upper != null && OWLRealUtils.compare(lower, upper) > 0) {
            throw new IllegalArgumentException();
        }
        IntegerInterval i = new IntegerInterval(lower == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(lower), upper == null ? (Number)null : (Number)OWLRealUtils.getCanonicalObject(upper));
        this.dataRange = new RestrictedRealDataRange(this, i, null, null);
    }

    @Override
    public RestrictedDataRange<Number> asDataRange() {
        return this.dataRange;
    }

    protected abstract Number fromLexicalForm(String var1) throws InvalidLiteralException;

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        String lexicalForm = input.getLexicalValue();
        this.fromLexicalForm(lexicalForm);
        return XSD_DECIMAL.getCanonicalRepresentation(TermFactory.literal(lexicalForm, XSD_DECIMAL.getName()));
    }

    @Override
    public Literal getLiteral(Object value) {
        if (this.dataRange.contains(value)) {
            return TermFactory.literal(OWLRealUtils.print((Number)value), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return XSDDecimal.getInstance();
    }

    @Override
    public Number getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        return OWLRealUtils.getCanonicalObject(this.fromLexicalForm(lexicalForm));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }
}

