/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.types.floating;

import com.clarkparsia.pellet.api.term.TermFactory;
import com.clarkparsia.pellet.api.term.builtins.Datatypes;
import com.clarkparsia.pellet.api.term.entity.Literal;
import com.clarkparsia.pellet.datatypes.AbstractBaseDatatype;
import com.clarkparsia.pellet.datatypes.Datatype;
import com.clarkparsia.pellet.datatypes.RestrictedDataRange;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.types.floating.IEEEDoubleType;
import com.clarkparsia.pellet.datatypes.types.floating.RestrictedFloatingPointDataRange;
import jakarta.xml.bind.DatatypeConverter;

public class XSDDouble
extends AbstractBaseDatatype<Double> {
    private static final XSDDouble instance = new XSDDouble();
    private final RestrictedFloatingPointDataRange<Double> dataRange = new RestrictedFloatingPointDataRange<Double>(this, IEEEDoubleType.getInstance());

    public static XSDDouble getInstance() {
        return instance;
    }

    private XSDDouble() {
        super(Datatypes.DOUBLE);
    }

    @Override
    public RestrictedDataRange<Double> asDataRange() {
        return this.dataRange;
    }

    @Override
    public Literal getCanonicalRepresentation(Literal input) throws InvalidLiteralException {
        Double f = this.getValue(input);
        String canonicalForm = DatatypeConverter.printDouble((double)f);
        if (canonicalForm.equals(input.getLexicalValue())) {
            return input;
        }
        return TermFactory.literal(canonicalForm, this.getName());
    }

    @Override
    public Literal getLiteral(Object value) {
        if (value instanceof Double) {
            return TermFactory.literal(DatatypeConverter.printDouble((double)((Double)value)), this.getName());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Datatype<?> getPrimitiveDatatype() {
        return this;
    }

    @Override
    public Double getValue(Literal literal) throws InvalidLiteralException {
        String lexicalForm = literal.getLexicalValue();
        try {
            return DatatypeConverter.parseDouble((String)lexicalForm);
        }
        catch (NumberFormatException e) {
            throw new InvalidLiteralException(this.getName(), literal);
        }
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }
}

